/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class JarClassPath
implements ClassPath {
    Set<String> jarfileEntries;
    String jarfileURL;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JarClassPath(String pathname2222) throws NotFoundException {
        JarFile jarfile = null;
        try {
            jarfile = new JarFile(pathname2222);
            this.jarfileEntries = new HashSet<String>();
            for (JarEntry je : Collections.list(jarfile.entries())) {
                if (!je.getName().endsWith(".class")) continue;
                this.jarfileEntries.add(je.getName());
            }
            this.jarfileURL = new File(pathname2222).getCanonicalFile().toURI().toURL().toString();
        }
        catch (IOException iOException) {
            void var1_1;
            if (jarfile == null) throw new NotFoundException((String)var1_1);
            try {
                jarfile.close();
                throw new NotFoundException((String)var1_1);
            }
            catch (IOException iOException2) {
                throw new NotFoundException((String)var1_1);
            }
        }
        catch (Throwable pathname2222) {
            if (jarfile == null) throw pathname2222;
            try {
                void var2_3;
                var2_3.close();
                throw pathname2222;
            }
            catch (IOException iOException) {}
            throw pathname2222;
        }
        try {
            jarfile.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final InputStream openClassfile(String classname) throws NotFoundException {
        URL jarURL = this.find(classname);
        if (jarURL != null) {
            try {
                void var2_2;
                if (ClassPool.cacheOpenedJarFile) {
                    return jarURL.openConnection().getInputStream();
                }
                URLConnection con = jarURL.openConnection();
                con.setUseCaches(false);
                return var2_2.getInputStream();
            }
            catch (IOException iOException) {
                void var1_1;
                throw new NotFoundException("broken jar file?: " + (String)var1_1);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final URL find(String classname) {
        String jarname = classname.replace('.', '/') + ".class";
        if (this.jarfileEntries.contains(jarname)) {
            try {
                void var1_1;
                return new URL(String.format("jar:%s!/%s", this.jarfileURL, var1_1));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public final String toString() {
        if (this.jarfileURL == null) {
            return "<null>";
        }
        return this.jarfileURL;
    }
}

