/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClassType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewConstructor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import java.io.DataOutputStream;
import java.io.IOException;

class CtNewClass
extends CtClassType {
    protected boolean hasConstructor;

    /*
     * WARNING - void declaration
     */
    CtNewClass(String name, ClassPool cp, boolean isInterface, CtClass superclass) {
        super(name, cp);
        void var3_3;
        void var2_2;
        void var1_1;
        this.wasChanged = true;
        String superName = isInterface || superclass == null ? null : superclass.getName();
        this.classfile = new ClassFile(isInterface, (String)var1_1, (String)var2_2);
        if (isInterface && superclass != null) {
            this.classfile.setInterfaces(new String[]{superclass.getName()});
        }
        CtNewClass ctNewClass = this;
        ((CtClass)ctNewClass).setModifiers(Modifier.setPublic(((CtClass)ctNewClass).getModifiers()));
        this.hasConstructor = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void extendToString(StringBuilder buffer) {
        void var1_1;
        if (this.hasConstructor) {
            buffer.append("hasConstructor ");
        }
        super.extendToString((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConstructor(CtConstructor c2) throws CannotCompileException {
        void var1_1;
        this.hasConstructor = true;
        super.addConstructor((CtConstructor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void toBytecode(DataOutputStream out) throws CannotCompileException, IOException {
        void var1_1;
        if (!this.hasConstructor) {
            try {
                this.inheritAllConstructors();
                this.hasConstructor = true;
            }
            catch (NotFoundException e2) {
                void var1_2;
                throw new CannotCompileException((NotFoundException)var1_2);
            }
        }
        super.toBytecode((DataOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void inheritAllConstructors() throws CannotCompileException, NotFoundException {
        void var3_3;
        CtClass superclazz = ((CtClass)this).getSuperclass();
        CtConstructor[] cs = superclazz.getDeclaredConstructors();
        int n2 = 0;
        for (int i2 = 0; i2 < cs.length; ++i2) {
            CtConstructor c2 = cs[i2];
            int mod = ((CtMember)c2).getModifiers();
            if (!this.isInheritable(mod, superclazz)) continue;
            CtConstructor cons = CtNewConstructor.make(c2.getParameterTypes(), c2.getExceptionTypes(), this);
            ((CtMember)cons).setModifiers(mod & 7);
            ((CtClass)this).addConstructor(cons);
            ++n2;
        }
        if (var3_3 <= 0) {
            void var1_1;
            throw new CannotCompileException("no inheritable constructor in " + var1_1.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInheritable(int mod, CtClass superclazz) {
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isPackage(mod)) {
            void var2_3;
            void var1_2;
            String pname = this.getPackageName();
            String pname2 = superclazz.getPackageName();
            if (pname == null) {
                return pname2 == null;
            }
            return var1_2.equals(var2_3);
        }
        return true;
    }
}

