/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtBehavior;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMember;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.Modifier;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.BadBytecode;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeAttribute;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.CodeIterator;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ConstPool;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.MethodInfo;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformAccessArrayField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformAfter;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformBefore;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformCall;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformCallToStatic;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformFieldAccess;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformNew;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformNewClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformReadField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.TransformWriteField;
import com.alibaba.ttl.threadpool.agent.internal.javassist.convert.Transformer;

public class CodeConverter {
    protected Transformer transformers = null;

    /*
     * WARNING - void declaration
     */
    public void replaceNew(CtClass newClass, CtClass calledClass, String calledMethod) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.transformers = new TransformNew(this.transformers, var1_1.getName(), var2_2.getName(), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void replaceNew(CtClass oldClass, CtClass newClass) {
        void var2_2;
        void var1_1;
        this.transformers = new TransformNewClass(this.transformers, var1_1.getName(), var2_2.getName());
    }

    /*
     * WARNING - void declaration
     */
    public void redirectFieldAccess(CtField field, CtClass newClass, String newFieldname) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.transformers = new TransformFieldAccess(this.transformers, (CtField)var1_1, var2_2.getName(), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void replaceFieldRead(CtField field, CtClass calledClass, String calledMethod) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.transformers = new TransformReadField(this.transformers, (CtField)var1_1, var2_2.getName(), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void replaceFieldWrite(CtField field, CtClass calledClass, String calledMethod) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.transformers = new TransformWriteField(this.transformers, (CtField)var1_1, var2_2.getName(), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void replaceArrayAccess(CtClass calledClass, ArrayAccessReplacementMethodNames names) throws NotFoundException {
        void var2_2;
        void var1_1;
        this.transformers = new TransformAccessArrayField(this.transformers, var1_1.getName(), (ArrayAccessReplacementMethodNames)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void redirectMethodCall(CtMethod origMethod, CtMethod substMethod) throws CannotCompileException {
        void var2_2;
        void var1_1;
        void var3_4;
        String d2;
        String d1 = origMethod.getMethodInfo2().getDescriptor();
        if (!d1.equals(d2 = substMethod.getMethodInfo2().getDescriptor())) {
            throw new CannotCompileException("signature mismatch: " + ((CtBehavior)substMethod).getLongName());
        }
        int mod1 = ((CtMember)origMethod).getModifiers();
        int mod2 = ((CtMember)substMethod).getModifiers();
        if (Modifier.isStatic(mod1) != Modifier.isStatic(mod2) || Modifier.isPrivate((int)var3_4) && !Modifier.isPrivate(mod2) || origMethod.getDeclaringClass().isInterface() != substMethod.getDeclaringClass().isInterface()) {
            throw new CannotCompileException("invoke-type mismatch " + ((CtBehavior)substMethod).getLongName());
        }
        this.transformers = new TransformCall(this.transformers, (CtMethod)var1_1, (CtMethod)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void redirectMethodCall(String oldMethodName, CtMethod newMethod) throws CannotCompileException {
        void var2_2;
        void var1_1;
        this.transformers = new TransformCall(this.transformers, (String)var1_1, (CtMethod)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void redirectMethodCallToStatic(CtMethod origMethod, CtMethod staticMethod) {
        void var2_2;
        void var1_1;
        this.transformers = new TransformCallToStatic(this.transformers, (CtMethod)var1_1, (CtMethod)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void insertBeforeMethod(CtMethod origMethod, CtMethod beforeMethod) throws CannotCompileException {
        try {
            void var2_3;
            this.transformers = new TransformBefore(this.transformers, origMethod, (CtMethod)var2_3);
            return;
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new CannotCompileException((NotFoundException)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void insertAfterMethod(CtMethod origMethod, CtMethod afterMethod) throws CannotCompileException {
        try {
            void var2_3;
            this.transformers = new TransformAfter(this.transformers, origMethod, (CtMethod)var2_3);
            return;
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new CannotCompileException((NotFoundException)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doit(CtClass clazz, MethodInfo minfo, ConstPool cp) throws CannotCompileException {
        Transformer t2;
        CodeAttribute codeAttr = minfo.getCodeAttribute();
        if (codeAttr == null || this.transformers == null) {
            return;
        }
        for (t2 = this.transformers; t2 != null; t2 = t2.getNext()) {
            t2.initialize(cp, clazz, minfo);
        }
        CodeIterator iterator2 = codeAttr.iterator();
        while (iterator2.hasNext()) {
            try {
                int pos = iterator2.next();
                for (t2 = this.transformers; t2 != null; t2 = t2.getNext()) {
                    pos = t2.transform(clazz, pos, iterator2, cp);
                }
            }
            catch (BadBytecode e2) {
                throw new CannotCompileException(e2);
            }
        }
        int locals = 0;
        int stack = 0;
        for (t2 = this.transformers; t2 != null; t2 = t2.getNext()) {
            int s2 = t2.extraLocals();
            if (s2 > locals) {
                locals = s2;
            }
            if ((s2 = t2.extraStack()) <= stack) continue;
            stack = s2;
        }
        for (t2 = this.transformers; t2 != null; t2 = t2.getNext()) {
            t2.clean();
        }
        if (locals > 0) {
            CodeAttribute codeAttribute = codeAttr;
            codeAttribute.setMaxLocals(codeAttribute.getMaxLocals() + locals);
        }
        if (stack > 0) {
            void var3_4;
            CodeAttribute codeAttribute = codeAttr;
            codeAttribute.setMaxStack(codeAttribute.getMaxStack() + var3_4);
        }
        try {
            void var1_1;
            void var2_2;
            var2_2.rebuildStackMapIf6(clazz.getClassPool(), var1_1.getClassFile2());
            return;
        }
        catch (BadBytecode b2) {
            throw new CannotCompileException(b2.getMessage(), b2);
        }
    }

    public static interface ArrayAccessReplacementMethodNames {
        public String byteOrBooleanRead();

        public String byteOrBooleanWrite();

        public String charRead();

        public String charWrite();

        public String doubleRead();

        public String doubleWrite();

        public String floatRead();

        public String floatWrite();

        public String intRead();

        public String intWrite();

        public String longRead();

        public String longWrite();

        public String objectRead();

        public String objectWrite();

        public String shortRead();

        public String shortWrite();
    }

    public static class DefaultArrayAccessReplacementMethodNames
    implements ArrayAccessReplacementMethodNames {
        @Override
        public String byteOrBooleanRead() {
            return "arrayReadByteOrBoolean";
        }

        @Override
        public String byteOrBooleanWrite() {
            return "arrayWriteByteOrBoolean";
        }

        @Override
        public String charRead() {
            return "arrayReadChar";
        }

        @Override
        public String charWrite() {
            return "arrayWriteChar";
        }

        @Override
        public String doubleRead() {
            return "arrayReadDouble";
        }

        @Override
        public String doubleWrite() {
            return "arrayWriteDouble";
        }

        @Override
        public String floatRead() {
            return "arrayReadFloat";
        }

        @Override
        public String floatWrite() {
            return "arrayWriteFloat";
        }

        @Override
        public String intRead() {
            return "arrayReadInt";
        }

        @Override
        public String intWrite() {
            return "arrayWriteInt";
        }

        @Override
        public String longRead() {
            return "arrayReadLong";
        }

        @Override
        public String longWrite() {
            return "arrayWriteLong";
        }

        @Override
        public String objectRead() {
            return "arrayReadObject";
        }

        @Override
        public String objectWrite() {
            return "arrayWriteObject";
        }

        @Override
        public String shortRead() {
            return "arrayReadShort";
        }

        @Override
        public String shortWrite() {
            return "arrayWriteShort";
        }
    }
}

