/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent.internal.javassist;

import com.alibaba.ttl.threadpool.agent.internal.javassist.CannotCompileException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPath;
import com.alibaba.ttl.threadpool.agent.internal.javassist.ClassPoolTail;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtArray;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtClassType;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtMethod;
import com.alibaba.ttl.threadpool.agent.internal.javassist.CtNewClass;
import com.alibaba.ttl.threadpool.agent.internal.javassist.NotFoundException;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.ClassFile;
import com.alibaba.ttl.threadpool.agent.internal.javassist.bytecode.Descriptor;
import com.alibaba.ttl.threadpool.agent.internal.javassist.util.proxy.DefineClassHelper;
import com.alibaba.ttl.threadpool.agent.internal.javassist.util.proxy.DefinePackageHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ClassPool {
    public boolean childFirstLookup = false;
    public static boolean doPruning = false;
    private int compressCount;
    private static final int COMPRESS_THRESHOLD = 100;
    public static boolean releaseUnmodifiedClassFile = true;
    public static boolean cacheOpenedJarFile = true;
    protected ClassPoolTail source;
    protected ClassPool parent;
    protected Hashtable classes = new Hashtable(191);
    private Hashtable cflow = null;
    private static final int INIT_HASH_SIZE = 191;
    private ArrayList importedPackages;
    private static ClassPool defaultPool = null;

    public ClassPool() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    public ClassPool(boolean useDefaultPath) {
        this(null);
        void var1_1;
        if (var1_1 != false) {
            this.appendSystemPath();
        }
    }

    public ClassPool(ClassPool parent) {
        this.source = new ClassPoolTail();
        this.parent = parent;
        if (parent == null) {
            CtClass[] pt = CtClass.primitiveTypes;
            for (int i2 = 0; i2 < pt.length; ++i2) {
                this.classes.put(pt[i2].getName(), pt[i2]);
            }
        }
        this.cflow = null;
        this.compressCount = 0;
        this.clearImportedPackages();
    }

    public static synchronized ClassPool getDefault() {
        if (defaultPool == null) {
            defaultPool = new ClassPool(null);
            defaultPool.appendSystemPath();
        }
        return defaultPool;
    }

    /*
     * WARNING - void declaration
     */
    protected CtClass getCached(String classname) {
        void var1_1;
        return (CtClass)this.classes.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void cacheCtClass(String classname, CtClass c2, boolean dynamic) {
        void var2_2;
        void var1_1;
        this.classes.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected CtClass removeCached(String classname) {
        void var1_1;
        return (CtClass)this.classes.remove(var1_1);
    }

    public String toString() {
        return this.source.toString();
    }

    void compress() {
        if (this.compressCount++ > 100) {
            this.compressCount = 0;
            Enumeration e2 = this.classes.elements();
            while (e2.hasMoreElements()) {
                ((CtClass)e2.nextElement()).compress();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void importPackage(String packageName) {
        void var1_1;
        this.importedPackages.add(var1_1);
    }

    public void clearImportedPackages() {
        this.importedPackages = new ArrayList();
        this.importedPackages.add("java.lang");
    }

    public Iterator<String> getImportedPackages() {
        return this.importedPackages.iterator();
    }

    public void recordInvalidClassName(String name) {
    }

    /*
     * WARNING - void declaration
     */
    void recordCflow(String name, String cname, String fname) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        this.cflow.put(var1_1, new Object[]{var2_2, var3_3});
    }

    /*
     * WARNING - void declaration
     */
    public Object[] lookupCflow(String name) {
        void var1_1;
        if (this.cflow == null) {
            this.cflow = new Hashtable();
        }
        return (Object[])this.cflow.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass getAndRename(String orgName, String newName) throws NotFoundException {
        void var3_3;
        void var2_2;
        CtClass clazz = this.get0(orgName, false);
        if (clazz == null) {
            void var1_1;
            throw new NotFoundException((String)var1_1);
        }
        if (clazz instanceof CtClassType) {
            ((CtClassType)clazz).setClassPool(this);
        }
        clazz.setName((String)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    synchronized void classNameChanged(String oldname, CtClass clazz) {
        void var2_2;
        void var1_1;
        CtClass ctClass = this.getCached(oldname);
        if (ctClass == clazz) {
            this.removeCached(oldname);
        }
        String newName = clazz.getName();
        this.checkNotFrozen(newName);
        this.cacheCtClass((String)var1_1, (CtClass)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass get(String classname) throws NotFoundException {
        void var2_2;
        CtClass clazz = classname == null ? null : this.get0(classname, true);
        if (clazz == null) {
            void var1_1;
            throw new NotFoundException((String)var1_1);
        }
        clazz.incGetCounter();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass getOrNull(String classname) {
        void var2_2;
        CtClass clazz = null;
        if (classname == null) {
            clazz = null;
        } else {
            try {
                void var1_1;
                clazz = this.get0((String)var1_1, true);
            }
            catch (NotFoundException notFoundException) {}
        }
        if (clazz != null) {
            clazz.incGetCounter();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass getCtClass(String classname) throws NotFoundException {
        void var1_1;
        if (classname.charAt(0) == '[') {
            return Descriptor.toCtClass(classname, this);
        }
        return this.get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized CtClass get0(String classname, boolean useCache) throws NotFoundException {
        void var3_3;
        CtClass clazz;
        if (useCache && (clazz = this.getCached(classname)) != null) {
            return clazz;
        }
        if (!this.childFirstLookup && this.parent != null && (clazz = this.parent.get0(classname, useCache)) != null) {
            return clazz;
        }
        clazz = this.createCtClass(classname, useCache);
        if (clazz != null) {
            if (useCache) {
                this.cacheCtClass(clazz.getName(), clazz, false);
            }
            return clazz;
        }
        if (this.childFirstLookup && this.parent != null) {
            void var2_2;
            void var1_1;
            clazz = this.parent.get0((String)var1_1, (boolean)var2_2);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected CtClass createCtClass(String classname, boolean useCache) {
        void var1_1;
        if (classname.charAt(0) == '[') {
            classname = Descriptor.toClassName(classname);
        }
        if (classname.endsWith("[]")) {
            void var3_3;
            void var2_2;
            String base = classname.substring(0, classname.indexOf(91));
            if ((var2_2 == false || this.getCached(base) == null) && this.find((String)var3_3) == null) {
                return null;
            }
            return new CtArray(classname, this);
        }
        if (this.find(classname) == null) {
            return null;
        }
        return new CtClassType((String)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public URL find(String classname) {
        void var1_1;
        return this.source.find((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void checkNotFrozen(String classname) throws RuntimeException {
        void var2_2;
        CtClass clazz = this.getCached(classname);
        if (clazz == null) {
            if (!this.childFirstLookup && this.parent != null) {
                try {
                    clazz = this.parent.get0(classname, true);
                }
                catch (NotFoundException notFoundException) {}
                if (clazz != null) {
                    throw new RuntimeException(classname + " is in a parent ClassPool.  Use the parent.");
                }
            }
        } else if (var2_2.isFrozen()) {
            void var1_1;
            throw new RuntimeException((String)var1_1 + ": frozen class (cannot edit)");
        }
    }

    /*
     * WARNING - void declaration
     */
    CtClass checkNotExists(String classname) {
        void var2_2;
        CtClass clazz = this.getCached(classname);
        if (clazz == null && !this.childFirstLookup && this.parent != null) {
            try {
                void var1_1;
                clazz = this.parent.get0((String)var1_1, true);
            }
            catch (NotFoundException notFoundException) {}
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    InputStream openClassfile(String classname) throws NotFoundException {
        void var1_1;
        return this.source.openClassfile((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        void var2_2;
        void var1_1;
        this.source.writeClassfile((String)var1_1, (OutputStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass[] get(String[] classnames) throws NotFoundException {
        void var3_3;
        if (classnames == null) {
            return new CtClass[0];
        }
        int num = classnames.length;
        CtClass[] result = new CtClass[num];
        for (int i2 = 0; i2 < num; ++i2) {
            result[i2] = this.get(classnames[i2]);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public CtMethod getMethod(String classname, String methodname) throws NotFoundException {
        void var2_2;
        CtClass ctClass;
        ctClass = this.get((String)((Object)ctClass));
        return ctClass.getDeclaredMethod((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeClass(InputStream classfile) throws IOException, RuntimeException {
        void var1_1;
        return this.makeClass((InputStream)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeClass(InputStream classfile, boolean ifNotFrozen) throws IOException, RuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        this.compress();
        classfile = new BufferedInputStream(classfile);
        CtClassType clazz = new CtClassType(classfile, this);
        ((CtClass)clazz).checkModify();
        String classname = clazz.getName();
        if (var2_2 != false) {
            this.checkNotFrozen(classname);
        }
        this.cacheCtClass((String)var3_3, clazz, true);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeClass(ClassFile classfile) throws RuntimeException {
        void var1_1;
        return this.makeClass((ClassFile)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeClass(ClassFile classfile, boolean ifNotFrozen) throws RuntimeException {
        void var1_1;
        void var3_3;
        void var2_2;
        this.compress();
        CtClassType clazz = new CtClassType(classfile, this);
        ((CtClass)clazz).checkModify();
        String classname = clazz.getName();
        if (var2_2 != false) {
            this.checkNotFrozen(classname);
        }
        this.cacheCtClass((String)var3_3, clazz, true);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeClassIfNew(InputStream classfile) throws IOException, RuntimeException {
        void var1_1;
        void var2_2;
        this.compress();
        classfile = new BufferedInputStream(classfile);
        CtClassType clazz = new CtClassType(classfile, this);
        ((CtClass)clazz).checkModify();
        String classname = clazz.getName();
        CtClass found = this.checkNotExists(classname);
        if (found != null) {
            void var3_3;
            return var3_3;
        }
        this.cacheCtClass((String)var2_2, clazz, true);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeClass(String classname) throws RuntimeException {
        void var1_1;
        return this.makeClass((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized CtClass makeClass(String classname, CtClass superclass) throws RuntimeException {
        void var2_2;
        void var1_1;
        this.checkNotFrozen(classname);
        CtNewClass clazz = new CtNewClass(classname, this, false, superclass);
        this.cacheCtClass((String)var1_1, clazz, true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    synchronized CtClass makeNestedClass(String classname) {
        void var2_2;
        void var1_1;
        this.checkNotFrozen(classname);
        CtNewClass clazz = new CtNewClass(classname, this, false, null);
        this.cacheCtClass((String)var1_1, clazz, true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeInterface(String name) throws RuntimeException {
        void var1_1;
        return this.makeInterface((String)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized CtClass makeInterface(String name, CtClass superclass) throws RuntimeException {
        void var2_2;
        void var1_1;
        this.checkNotFrozen(name);
        CtNewClass clazz = new CtNewClass(name, this, true, superclass);
        this.cacheCtClass((String)var1_1, clazz, true);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CtClass makeAnnotation(String name) throws RuntimeException {
        try {
            CtClass cc = this.makeInterface(name, this.get("java.lang.annotation.Annotation"));
            cc.setModifiers(cc.getModifiers() | 0x2000);
            return cc;
        }
        catch (NotFoundException e2) {
            void var1_2;
            throw new RuntimeException(e2.getMessage(), (Throwable)var1_2);
        }
    }

    public ClassPath appendSystemPath() {
        return this.source.appendSystemPath();
    }

    /*
     * WARNING - void declaration
     */
    public ClassPath insertClassPath(ClassPath cp) {
        void var1_1;
        return this.source.insertClassPath((ClassPath)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassPath appendClassPath(ClassPath cp) {
        void var1_1;
        return this.source.appendClassPath((ClassPath)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassPath insertClassPath(String pathname) throws NotFoundException {
        void var1_1;
        return this.source.insertClassPath((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ClassPath appendClassPath(String pathname) throws NotFoundException {
        void var1_1;
        return this.source.appendClassPath((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeClassPath(ClassPath cp) {
        void var1_1;
        this.source.removeClassPath((ClassPath)var1_1);
    }

    public void appendPathList(String pathlist) throws NotFoundException {
        char sep = File.pathSeparatorChar;
        int i2 = 0;
        while (true) {
            int j2;
            if ((j2 = pathlist.indexOf(sep, i2)) < 0) {
                this.appendClassPath(pathlist.substring(i2));
                return;
            }
            this.appendClassPath(pathlist.substring(i2, j2));
            i2 = j2 + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Class toClass(CtClass clazz) throws CannotCompileException {
        void var1_1;
        return this.toClass((CtClass)var1_1, this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return ClassPool.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    /*
     * WARNING - void declaration
     */
    public Class toClass(CtClass ct, ClassLoader loader) throws CannotCompileException {
        void var2_2;
        void var1_1;
        return this.toClass((CtClass)var1_1, null, (ClassLoader)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public Class toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.toClass((CtClass)var1_1, null, (ClassLoader)var2_2, (ProtectionDomain)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> toClass(CtClass ct, Class<?> neighbor) throws CannotCompileException {
        try {
            return DefineClassHelper.toClass(neighbor, ct.toBytecode());
        }
        catch (IOException e2) {
            void var1_2;
            throw new CannotCompileException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Class<?> toClass(CtClass ct, MethodHandles.Lookup lookup) throws CannotCompileException {
        try {
            return DefineClassHelper.toClass(lookup, ct.toBytecode());
        }
        catch (IOException e2) {
            void var1_2;
            throw new CannotCompileException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Class toClass(CtClass ct, Class<?> neighbor, ClassLoader loader, ProtectionDomain domain) throws CannotCompileException {
        try {
            void var3_4;
            void var2_3;
            return DefineClassHelper.toClass(ct.getName(), var2_3, (ClassLoader)var3_4, domain, ct.toBytecode());
        }
        catch (IOException e2) {
            void var1_2;
            throw new CannotCompileException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void makePackage(ClassLoader loader, String name) throws CannotCompileException {
        void var1_1;
        DefinePackageHelper.definePackage(name, (ClassLoader)var1_1);
    }
}

