/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl.threadpool.agent;

import com.alibaba.ttl.threadpool.agent.internal.logging.Logger;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.ClassInfo;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.JavassistTransformlet;
import com.alibaba.ttl.threadpool.agent.internal.transformlet.impl.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class TtlTransformer
implements ClassFileTransformer {
    private static final Logger logger = Logger.getLogger(TtlTransformer.class);
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    private static final byte[] NO_TRANSFORM = null;
    private final List<JavassistTransformlet> transformletList = new ArrayList<JavassistTransformlet>();

    /*
     * WARNING - void declaration
     */
    TtlTransformer(List<? extends JavassistTransformlet> transformletList) {
        Iterator iterator2;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_2;
            JavassistTransformlet transformlet = (JavassistTransformlet)iterator2.next();
            this.transformletList.add(transformlet);
            logger.info("[TtlTransformer] add Transformlet " + var2_2.getClass() + " success");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] transform(@Nullable ClassLoader loader, @Nullable String classFile, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, @NonNull byte[] classFileBuffer) {
        try {
            if (classFile == null) {
                return NO_TRANSFORM;
            }
            String className = TtlTransformer.toClassName(classFile);
            if (Utils.isClassUnderPackage(className, "com.alibaba.ttl")) {
                return NO_TRANSFORM;
            }
            if (Utils.isClassUnderPackage(className, "java.lang")) {
                return NO_TRANSFORM;
            }
            ClassInfo classInfo = new ClassInfo(className, classFileBuffer, loader);
            for (JavassistTransformlet javassistTransformlet : this.transformletList) {
                javassistTransformlet.doTransform(classInfo);
                if (!classInfo.isModified()) continue;
                return classInfo.getCtClass().toBytecode();
            }
        }
        catch (Throwable t2) {
            void var3_4;
            void var1_1;
            void var2_2;
            String msg = "Fail to transform class " + (String)var2_2 + ", cause: " + t2;
            logger.log(Level.SEVERE, msg, t2);
            throw new IllegalStateException((String)var1_1, (Throwable)var3_4);
        }
        return NO_TRANSFORM;
    }

    private static String toClassName(@NonNull String classFile) {
        return classFile.replace('/', '.');
    }
}

