/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ttl;

import com.alibaba.ttl.TtlCopier;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.TestOnly;

public class TransmittableThreadLocal<T>
extends InheritableThreadLocal<T>
implements TtlCopier<T> {
    private static final Logger logger = Logger.getLogger(TransmittableThreadLocal.class.getName());
    private final boolean disableIgnoreNullValueSemantics;
    private static final InheritableThreadLocal<WeakHashMap<TransmittableThreadLocal<Object>, ?>> holder = new InheritableThreadLocal<WeakHashMap<TransmittableThreadLocal<Object>, ?>>(){

        @Override
        protected WeakHashMap<TransmittableThreadLocal<Object>, ?> initialValue() {
            return new WeakHashMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected WeakHashMap<TransmittableThreadLocal<Object>, ?> childValue(WeakHashMap<TransmittableThreadLocal<Object>, ?> parentValue) {
            void var1_1;
            return new WeakHashMap(var1_1);
        }
    };

    public TransmittableThreadLocal() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public TransmittableThreadLocal(boolean disableIgnoreNullValueSemantics) {
        void var1_1;
        this.disableIgnoreNullValueSemantics = var1_1;
    }

    @NonNull
    public static <S> TransmittableThreadLocal<S> withInitial(@NonNull Supplier<? extends S> supplier) {
        Supplier<? extends S> supplier2;
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        return new SuppliedTransmittableThreadLocal<S>(supplier2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    @ParametersAreNonnullByDefault
    @NonNull
    public static <S> TransmittableThreadLocal<S> withInitialAndCopier(Supplier<? extends S> supplier, TtlCopier<S> copierForChildValueAndCopy) {
        Supplier<? extends S> supplier2;
        void var1_1;
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        if (copierForChildValueAndCopy == null) {
            throw new NullPointerException("ttl copier is null");
        }
        void v0 = var1_1;
        return new SuppliedTransmittableThreadLocal<S>(supplier2, v0, v0);
    }

    /*
     * WARNING - void declaration
     */
    @ParametersAreNonnullByDefault
    @NonNull
    public static <S> TransmittableThreadLocal<S> withInitialAndCopier(Supplier<? extends S> supplier, TtlCopier<S> copierForChildValue, TtlCopier<S> copierForCopy) {
        void var2_2;
        void var1_1;
        Supplier<? extends S> supplier2;
        if (supplier == null) {
            throw new NullPointerException("supplier is null");
        }
        if (copierForChildValue == null) {
            throw new NullPointerException("ttl copier for child value is null");
        }
        if (copierForCopy == null) {
            throw new NullPointerException("ttl copier for copy value is null");
        }
        return new SuppliedTransmittableThreadLocal<S>(supplier2, var1_1, var2_2);
    }

    @Override
    public T copy(T parentValue) {
        return parentValue;
    }

    protected void beforeExecute() {
    }

    protected void afterExecute() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final T get() {
        void var1_1;
        Object value = super.get();
        if (this.disableIgnoreNullValueSemantics || value != null) {
            this.addThisToHolder();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void set(T value) {
        void var1_1;
        if (!this.disableIgnoreNullValueSemantics && value == null) {
            this.remove();
            return;
        }
        super.set(var1_1);
        this.addThisToHolder();
    }

    @Override
    public final void remove() {
        this.removeThisFromHolder();
        super.remove();
    }

    private void superRemove() {
        super.remove();
    }

    private T copyValue() {
        TransmittableThreadLocal transmittableThreadLocal = this;
        return transmittableThreadLocal.copy(transmittableThreadLocal.get());
    }

    private void addThisToHolder() {
        if (!((WeakHashMap)holder.get()).containsKey(this)) {
            ((WeakHashMap)holder.get()).put(this, null);
        }
    }

    private void removeThisFromHolder() {
        ((WeakHashMap)holder.get()).remove(this);
    }

    /*
     * WARNING - void declaration
     */
    private static void doExecuteCallback(boolean isBefore) {
        WeakHashMap weakHashMap = new WeakHashMap((Map)holder.get());
        for (TransmittableThreadLocal threadLocal : weakHashMap.keySet()) {
            try {
                if (isBefore) {
                    threadLocal.beforeExecute();
                    continue;
                }
                threadLocal.afterExecute();
            }
            catch (Throwable t2) {
                void var2_3;
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "TTL exception when " + (isBefore ? "beforeExecute" : "afterExecute") + ", cause: " + t2, (Throwable)var2_3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    static void dump(@Nullable String title) {
        if (title != null && title.length() > 0) {
            Object object;
            System.out.printf("Start TransmittableThreadLocal[%s] Dump...%n", object);
        } else {
            System.out.println("Start TransmittableThreadLocal Dump...");
        }
        for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
            void var1_1;
            System.out.println(var1_1.get());
        }
        System.out.println("TransmittableThreadLocal Dump end!");
    }

    @TestOnly
    static void dump() {
        TransmittableThreadLocal.dump(null);
    }

    public static class Transmitter {
        private static volatile WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> threadLocalHolder = new WeakHashMap();
        private static final Object threadLocalHolderUpdateLock = new Object();
        private static final Object threadLocalClearMark = new Object();
        private static final TtlCopier<Object> shadowCopier = parentValue -> parentValue;

        @NonNull
        public static Object capture() {
            return new Snapshot(Transmitter.captureTtlValues(), Transmitter.captureThreadLocalValues());
        }

        /*
         * WARNING - void declaration
         */
        private static HashMap<TransmittableThreadLocal<Object>, Object> captureTtlValues() {
            void var0;
            HashMap<void, Object> ttl2Value = new HashMap<void, Object>();
            for (TransmittableThreadLocal threadLocal : ((WeakHashMap)holder.get()).keySet()) {
                void var2_2;
                void v0 = var2_2;
                ttl2Value.put(v0, ((TransmittableThreadLocal)v0).copyValue());
            }
            return var0;
        }

        /*
         * WARNING - void declaration
         */
        private static HashMap<ThreadLocal<Object>, Object> captureThreadLocalValues() {
            void var0;
            HashMap threadLocal2Value = new HashMap();
            for (Map.Entry<ThreadLocal<Object>, TtlCopier<Object>> entry : threadLocalHolder.entrySet()) {
                void var3_3;
                void var2_2;
                ThreadLocal<Object> threadLocal = entry.getKey();
                TtlCopier<Object> copier = entry.getValue();
                threadLocal2Value.put(threadLocal, var2_2.copy(var3_3.get()));
            }
            return var0;
        }

        @NonNull
        public static Object replay(@NonNull Object captured) {
            Object object;
            Object capturedSnapshot = (Snapshot)captured;
            return new Snapshot(Transmitter.replayTtlValues(((Snapshot)capturedSnapshot).ttl2Value), Transmitter.replayThreadLocalValues(((Snapshot)object).threadLocal2Value));
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        private static HashMap<TransmittableThreadLocal<Object>, Object> replayTtlValues(@NonNull HashMap<TransmittableThreadLocal<Object>, Object> captured) {
            void var1_1;
            HashMap<TransmittableThreadLocal<Object>, Object> hashMap;
            HashMap backup = new HashMap();
            Iterator iterator2 = ((WeakHashMap)holder.get()).keySet().iterator();
            while (iterator2.hasNext()) {
                void var3_3;
                TransmittableThreadLocal threadLocal;
                TransmittableThreadLocal transmittableThreadLocal = threadLocal = (TransmittableThreadLocal)iterator2.next();
                backup.put(transmittableThreadLocal, transmittableThreadLocal.get());
                if (captured.containsKey(threadLocal)) continue;
                iterator2.remove();
                ((TransmittableThreadLocal)var3_3).superRemove();
            }
            Transmitter.setTtlValuesTo(hashMap);
            TransmittableThreadLocal.doExecuteCallback(true);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static HashMap<ThreadLocal<Object>, Object> replayThreadLocalValues(@NonNull HashMap<ThreadLocal<Object>, Object> captured) {
            void var1_1;
            Object object;
            HashMap backup = new HashMap();
            for (Map.Entry entry : ((HashMap)object).entrySet()) {
                void var3_4;
                ThreadLocal threadLocal;
                ThreadLocal threadLocal2 = threadLocal = (ThreadLocal)entry.getKey();
                backup.put(threadLocal2, threadLocal2.get());
                Object v2 = entry.getValue();
                if (v2 == threadLocalClearMark) {
                    threadLocal.remove();
                    continue;
                }
                var3_4.set(v2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static Object clear() {
            void var1_1;
            void var0;
            HashMap ttl2Value = new HashMap();
            HashMap<Map.Entry<ThreadLocal<Object>, TtlCopier<Object>>, Object> threadLocal2Value = new HashMap<Map.Entry<ThreadLocal<Object>, TtlCopier<Object>>, Object>();
            for (Map.Entry<ThreadLocal<Object>, TtlCopier<Object>> entry : threadLocalHolder.entrySet()) {
                ThreadLocal<Object> threadLocal = entry.getKey();
                threadLocal2Value.put(entry, threadLocalClearMark);
            }
            return Transmitter.replay(new Snapshot((HashMap)var0, (HashMap)var1_1));
        }

        public static void restore(@NonNull Object backup) {
            Object object;
            Object backupSnapshot = (Snapshot)backup;
            Transmitter.restoreTtlValues(((Snapshot)backupSnapshot).ttl2Value);
            Transmitter.restoreThreadLocalValues(((Snapshot)object).threadLocal2Value);
        }

        /*
         * WARNING - void declaration
         */
        private static void restoreTtlValues(@NonNull HashMap<TransmittableThreadLocal<Object>, Object> backup) {
            HashMap<TransmittableThreadLocal<Object>, Object> hashMap;
            TransmittableThreadLocal.doExecuteCallback(false);
            Iterator iterator2 = ((WeakHashMap)holder.get()).keySet().iterator();
            while (iterator2.hasNext()) {
                void var2_2;
                TransmittableThreadLocal threadLocal = (TransmittableThreadLocal)iterator2.next();
                if (backup.containsKey(threadLocal)) continue;
                iterator2.remove();
                ((TransmittableThreadLocal)var2_2).superRemove();
            }
            Transmitter.setTtlValuesTo(hashMap);
        }

        private static void setTtlValuesTo(@NonNull HashMap<TransmittableThreadLocal<Object>, Object> ttlValues) {
            for (Map.Entry entry : ttlValues.entrySet()) {
                TransmittableThreadLocal transmittableThreadLocal = (TransmittableThreadLocal)entry.getKey();
                transmittableThreadLocal.set(entry.getValue());
            }
        }

        private static void restoreThreadLocalValues(@NonNull HashMap<ThreadLocal<Object>, Object> backup) {
            for (Map.Entry entry : backup.entrySet()) {
                ThreadLocal threadLocal = (ThreadLocal)entry.getKey();
                threadLocal.set(entry.getValue());
            }
        }

        public static <R> R runSupplierWithCaptured(@NonNull Object captured, @NonNull Supplier<R> bizLogic) {
            Object t2;
            Object backup = Transmitter.replay(captured);
            try {
                t2 = t2.get();
            }
            catch (Throwable throwable) {
                Object object;
                Transmitter.restore(object);
                throw throwable;
            }
            Transmitter.restore(backup);
            return (R)t2;
        }

        /*
         * WARNING - void declaration
         */
        public static <R> R runSupplierWithClear(@NonNull Supplier<R> bizLogic) {
            Supplier<R> supplier;
            Object backup = Transmitter.clear();
            try {
                supplier = supplier.get();
            }
            catch (Throwable throwable) {
                void var1_2;
                Transmitter.restore(var1_2);
                throw throwable;
            }
            Transmitter.restore(backup);
            return (R)supplier;
        }

        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        public static <R> R runCallableWithCaptured(@NonNull Object captured, @NonNull Callable<R> bizLogic) throws Exception {
            Object v2;
            Object backup = Transmitter.replay(captured);
            try {
                v2 = v2.call();
            }
            catch (Throwable throwable) {
                Object object;
                Transmitter.restore(object);
                throw throwable;
            }
            Transmitter.restore(backup);
            return (R)v2;
        }

        /*
         * WARNING - void declaration
         */
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"})
        public static <R> R runCallableWithClear(@NonNull Callable<R> bizLogic) throws Exception {
            Callable<R> callable;
            Object backup = Transmitter.clear();
            try {
                callable = callable.call();
            }
            catch (Throwable throwable) {
                void var1_2;
                Transmitter.restore(var1_2);
                throw throwable;
            }
            Transmitter.restore(backup);
            return (R)callable;
        }

        /*
         * WARNING - void declaration
         */
        public static <T> boolean registerThreadLocal(@NonNull ThreadLocal<T> threadLocal, @NonNull TtlCopier<T> copier) {
            void var1_1;
            return Transmitter.registerThreadLocal(threadLocal, var1_1, false);
        }

        public static <T> boolean registerThreadLocalWithShadowCopier(@NonNull ThreadLocal<T> threadLocal) {
            return Transmitter.registerThreadLocal(threadLocal, shadowCopier, false);
        }

        /*
         * WARNING - void declaration
         */
        public static <T> boolean registerThreadLocal(@NonNull ThreadLocal<T> threadLocal, @NonNull TtlCopier<T> copier, boolean force) {
            if (threadLocal instanceof TransmittableThreadLocal) {
                logger.warning("register a TransmittableThreadLocal instance, this is unnecessary!");
                return true;
            }
            Object object = threadLocalHolderUpdateLock;
            synchronized (object) {
                void var2_4;
                void var1_2;
                ThreadLocal<T> threadLocal2;
                if (!force && threadLocalHolder.containsKey(threadLocal)) {
                    return false;
                }
                WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> newHolder = new WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>>(threadLocalHolder);
                newHolder.put(threadLocal2, (TtlCopier<Object>)var1_2);
                threadLocalHolder = var2_4;
                return true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public static <T> boolean registerThreadLocalWithShadowCopier(@NonNull ThreadLocal<T> threadLocal, boolean force) {
            void var1_1;
            return Transmitter.registerThreadLocal(threadLocal, shadowCopier, (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public static <T> boolean unregisterThreadLocal(@NonNull ThreadLocal<T> threadLocal) {
            if (threadLocal instanceof TransmittableThreadLocal) {
                logger.warning("unregister a TransmittableThreadLocal instance, this is unnecessary!");
                return true;
            }
            Object object = threadLocalHolderUpdateLock;
            synchronized (object) {
                void var2_3;
                ThreadLocal<T> threadLocal2;
                if (!threadLocalHolder.containsKey(threadLocal)) {
                    return false;
                }
                WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>> newHolder = new WeakHashMap<ThreadLocal<Object>, TtlCopier<Object>>(threadLocalHolder);
                newHolder.remove(threadLocal2);
                threadLocalHolder = var2_3;
                return true;
            }
        }

        private Transmitter() {
            throw new InstantiationError("Must not instantiate this class");
        }

        private static class Snapshot {
            final HashMap<TransmittableThreadLocal<Object>, Object> ttl2Value;
            final HashMap<ThreadLocal<Object>, Object> threadLocal2Value;

            /*
             * WARNING - void declaration
             */
            private Snapshot(HashMap<TransmittableThreadLocal<Object>, Object> ttl2Value, HashMap<ThreadLocal<Object>, Object> threadLocal2Value) {
                void var2_2;
                void var1_1;
                this.ttl2Value = var1_1;
                this.threadLocal2Value = var2_2;
            }
        }
    }

    private static final class SuppliedTransmittableThreadLocal<T>
    extends TransmittableThreadLocal<T> {
        private final Supplier<? extends T> supplier;
        private final TtlCopier<T> copierForChildValue;
        private final TtlCopier<T> copierForCopy;

        /*
         * WARNING - void declaration
         */
        SuppliedTransmittableThreadLocal(Supplier<? extends T> supplier, TtlCopier<T> copierForChildValue, TtlCopier<T> copierForCopy) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (supplier == null) {
                throw new NullPointerException("supplier is null");
            }
            this.supplier = var1_1;
            this.copierForChildValue = var2_2;
            this.copierForCopy = var3_3;
        }

        @Override
        protected final T initialValue() {
            return this.supplier.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final T childValue(T parentValue) {
            void var1_1;
            if (this.copierForChildValue != null) {
                return this.copierForChildValue.copy(parentValue);
            }
            return super.childValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T copy(T parentValue) {
            void var1_1;
            if (this.copierForCopy != null) {
                return this.copierForCopy.copy(parentValue);
            }
            return super.copy(var1_1);
        }
    }
}

