/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.BitcoinReceiverCollection;
import com.stripe.model.BitcoinTransactionCollection;
import com.stripe.model.DeletedBitcoinReceiver;
import com.stripe.model.ExternalAccount;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class BitcoinReceiver
extends ExternalAccount {
    String status;
    Long created;
    String currency;
    Integer amount;
    Integer amountReceived;
    Integer bitcoinAmount;
    Integer bitcoinAmountReceived;
    Boolean filled;
    Boolean active;
    Boolean rejectTransactions;
    String description;
    String inboundAddress;
    String refundAddress;
    String bitcoinUri;
    String email;
    String payment;
    BitcoinTransactionCollection transactions;
    Map<String, String> metadata;

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public Integer getAmountReceived() {
        return this.amountReceived;
    }

    public void setAmountReceived(Integer amountReceived) {
        this.amountReceived = amountReceived;
    }

    public Integer getBitcoinAmount() {
        return this.bitcoinAmount;
    }

    public void setBitcoinAmount(Integer bitcoinAmount) {
        this.bitcoinAmount = bitcoinAmount;
    }

    public Integer getBitcoinAmountReceived() {
        return this.bitcoinAmountReceived;
    }

    public void setBitcoinAmountReceived(Integer bitcoinAmountReceived) {
        this.bitcoinAmountReceived = bitcoinAmountReceived;
    }

    public Boolean getFilled() {
        return this.filled;
    }

    public void setFilled(Boolean filled) {
        this.filled = filled;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Boolean getRejectTransactions() {
        return this.rejectTransactions;
    }

    public void setRejectTransactions(Boolean rejectTransactions) {
        this.rejectTransactions = rejectTransactions;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getInboundAddress() {
        return this.inboundAddress;
    }

    public void setInboundAddress(String inboundAddress) {
        this.inboundAddress = inboundAddress;
    }

    public String getRefundAddress() {
        return this.refundAddress;
    }

    public void setRefundAddress(String refundAddress) {
        this.refundAddress = refundAddress;
    }

    public String getBitcoinUri() {
        return this.bitcoinUri;
    }

    public void setBitcoinUri(String bitcoinUri) {
        this.bitcoinUri = bitcoinUri;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPayment() {
        return this.payment;
    }

    public void setPayment(String payment) {
        this.payment = payment;
    }

    public BitcoinTransactionCollection getTransactions() {
        return this.transactions;
    }

    public void setTransactions(BitcoinTransactionCollection transactions) {
        this.transactions = transactions;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public static BitcoinReceiver create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.create(params, null);
    }

    public static BitcoinReceiver retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.retrieve(id, null);
    }

    public static BitcoinReceiverCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.all(params, null);
    }

    public static BitcoinReceiver create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.POST, String.format("%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers"), params, BitcoinReceiver.class, options);
    }

    public static BitcoinReceiver retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.GET, String.format("%s/%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers", id), null, BitcoinReceiver.class, options);
    }

    public static BitcoinReceiverCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.GET, String.format("%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers"), params, BitcoinReceiverCollection.class, options);
    }

    @Override
    public String getInstanceURL() {
        String result = super.getInstanceURL();
        if (result == null) {
            return String.format("%s/%s/%s", Stripe.getApiBase(), "v1/bitcoin/receivers", this.getId());
        }
        return result;
    }

    @Override
    public BitcoinReceiver update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public BitcoinReceiver update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.POST, this.getInstanceURL(), params, BitcoinReceiver.class, options);
    }

    @Override
    public DeletedBitcoinReceiver delete() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.delete(null);
    }

    @Override
    public DeletedBitcoinReceiver delete(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return BitcoinReceiver.request(APIResource.RequestMethod.DELETE, this.getInstanceURL(), null, DeletedBitcoinReceiver.class, options);
    }
}

