/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.query;

import com.stormpath.sdk.lang.Assert;
import java.io.Serializable;

public class Order
implements Serializable {
    private final String propertyName;
    private final boolean ascending;

    public Order(String propertyName, boolean ascending) {
        Assert.hasText((String)propertyName, (String)"propertyName cannot be null or empty.");
        this.propertyName = propertyName;
        this.ascending = ascending;
    }

    public static Order asc(String propertyName) {
        return new Order(propertyName, true);
    }

    public static Order desc(String propertyName) {
        return new Order(propertyName, false);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String toString() {
        return this.propertyName + ' ' + (this.isAscending() ? "asc" : "desc");
    }
}

