/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.query;

import com.stormpath.sdk.impl.query.Expansion;
import com.stormpath.sdk.impl.query.Pagination;
import com.stormpath.sdk.lang.Assert;

public class CollectionExpansion
extends Expansion {
    private final int limit;
    private final int offset;

    public CollectionExpansion(String name, int limit, int offset) {
        super(name);
        Assert.isTrue((limit > 0 || offset > 0 ? 1 : 0) != 0, (String)"Either a limit or offset (or both) must be specified.");
        this.limit = Pagination.sanitizeLimit(limit);
        this.offset = Pagination.sanitizeOffset(offset);
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.limit > 0 || this.offset > 0) {
            sb.append("(");
            if (this.offset > 0) {
                sb.append("offset:").append(this.offset);
            }
            if (this.limit > 0) {
                if (this.offset > 0) {
                    sb.append(",");
                }
                sb.append("limit:").append(this.limit);
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

