/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.group;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupMembership;
import com.stormpath.sdk.group.GroupMembershipList;
import com.stormpath.sdk.group.GroupOptions;
import com.stormpath.sdk.group.GroupStatus;
import com.stormpath.sdk.impl.directory.AbstractDirectoryEntity;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.group.DefaultGroupMembership;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.tenant.Tenant;
import java.util.Map;

public class DefaultGroup
extends AbstractDirectoryEntity
implements Group {
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StatusProperty<GroupStatus> STATUS = new StatusProperty<GroupStatus>(GroupStatus.class);
    static final ResourceReference<Directory> DIRECTORY = new ResourceReference<Directory>("directory", Directory.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final CollectionReference<AccountList, Account> ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
    static final CollectionReference<GroupMembershipList, GroupMembership> ACCOUNT_MEMBERSHIPS = new CollectionReference<GroupMembershipList, GroupMembership>("accountMemberships", GroupMembershipList.class, GroupMembership.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultGroup.createPropertyDescriptorMap(NAME, DESCRIPTION, STATUS, CUSTOM_DATA, DIRECTORY, TENANT, ACCOUNTS, ACCOUNT_MEMBERSHIPS);

    public DefaultGroup(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultGroup(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public void setName(String name) {
        this.setProperty(NAME, (Object)name);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
    }

    public GroupStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return GroupStatus.valueOf((String)value.toUpperCase());
    }

    public void setStatus(GroupStatus status) {
        this.setProperty(STATUS, (Object)status.name());
    }

    @Override
    public CustomData getCustomData() {
        return super.getCustomData();
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public Directory getDirectory() {
        return this.getResourceProperty(DIRECTORY);
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, queryParams);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, (Criteria)criteria);
    }

    public GroupMembershipList getAccountMemberships() {
        return (GroupMembershipList)this.getResourceProperty(ACCOUNT_MEMBERSHIPS);
    }

    public GroupMembership addAccount(Account account) {
        return DefaultGroupMembership.create(account, this, this.getDataStore());
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public void accept(AccountStoreVisitor visitor) {
        visitor.visit((Group)this);
    }

    @Override
    public void save() {
        this.applyCustomDataUpdatesIfNecessary();
        super.save();
    }

    public void saveWithResponseOptions(GroupOptions groupOptions) {
        Assert.notNull((Object)groupOptions, (String)"accountOptions can't be null.");
        this.applyCustomDataUpdatesIfNecessary();
        this.getDataStore().save(this, (Options)groupOptions);
    }
}

