/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.ds;

import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.directory.CustomData;
import com.stormpath.sdk.error.Error;
import com.stormpath.sdk.impl.account.DefaultAccount;
import com.stormpath.sdk.impl.cache.DisabledCacheManager;
import com.stormpath.sdk.impl.ds.CacheRegionNameResolver;
import com.stormpath.sdk.impl.ds.DefaultCacheRegionNameResolver;
import com.stormpath.sdk.impl.ds.DefaultResourceFactory;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.ds.JacksonMapMarshaller;
import com.stormpath.sdk.impl.ds.MapMarshaller;
import com.stormpath.sdk.impl.ds.QuerySanitizer;
import com.stormpath.sdk.impl.ds.ResourceFactory;
import com.stormpath.sdk.impl.ds.SanitizedQuery;
import com.stormpath.sdk.impl.error.DefaultError;
import com.stormpath.sdk.impl.http.HttpMethod;
import com.stormpath.sdk.impl.http.MediaType;
import com.stormpath.sdk.impl.http.QueryString;
import com.stormpath.sdk.impl.http.QueryStringFactory;
import com.stormpath.sdk.impl.http.Request;
import com.stormpath.sdk.impl.http.RequestExecutor;
import com.stormpath.sdk.impl.http.Response;
import com.stormpath.sdk.impl.http.support.DefaultRequest;
import com.stormpath.sdk.impl.http.support.Version;
import com.stormpath.sdk.impl.query.DefaultCriteria;
import com.stormpath.sdk.impl.query.DefaultOptions;
import com.stormpath.sdk.impl.resource.AbstractResource;
import com.stormpath.sdk.impl.resource.ArrayProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ReferenceFactory;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.util.StringInputStream;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.CollectionResource;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.resource.Saveable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStore
implements InternalDataStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStore.class);
    public static final String DEFAULT_SERVER_HOST = "api.stormpath.com";
    public static final int DEFAULT_API_VERSION = 1;
    private final RequestExecutor requestExecutor;
    private final ResourceFactory resourceFactory;
    private final MapMarshaller mapMarshaller;
    private volatile CacheManager cacheManager;
    private volatile CacheRegionNameResolver cacheRegionNameResolver;
    private final ReferenceFactory referenceFactory;
    private final String baseUrl;
    private final QueryStringFactory queryStringFactory;

    public DefaultDataStore(RequestExecutor requestExecutor) {
        this(requestExecutor, 1);
    }

    public DefaultDataStore(RequestExecutor requestExecutor, int apiVersion) {
        this(requestExecutor, "https://api.stormpath.com/v" + apiVersion);
    }

    public DefaultDataStore(RequestExecutor requestExecutor, String baseUrl) {
        Assert.notNull((Object)baseUrl, (String)"baseUrl cannot be null");
        Assert.notNull((Object)requestExecutor, (String)"RequestExecutor cannot be null.");
        this.baseUrl = baseUrl;
        this.requestExecutor = requestExecutor;
        this.resourceFactory = new DefaultResourceFactory(this);
        this.mapMarshaller = new JacksonMapMarshaller();
        this.queryStringFactory = new QueryStringFactory();
        this.cacheManager = new DisabledCacheManager();
        this.cacheRegionNameResolver = new DefaultCacheRegionNameResolver();
        this.referenceFactory = new ReferenceFactory();
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCacheRegionNameResolver(CacheRegionNameResolver cacheRegionNameResolver) {
        this.cacheRegionNameResolver = cacheRegionNameResolver;
    }

    public <T extends Resource> T instantiate(Class<T> clazz) {
        return this.resourceFactory.instantiate(clazz, new Object[0]);
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz, Map<String, Object> properties) {
        return this.resourceFactory.instantiate(clazz, properties);
    }

    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Resource class argument cannot be null.");
        SanitizedQuery sanitized = QuerySanitizer.sanitize(href, null);
        return this.getResource(sanitized.getHrefWithoutQuery(), clazz, sanitized.getQuery());
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Map<String, Object> queryParameters) {
        SanitizedQuery sanitized = QuerySanitizer.sanitize(href, queryParameters);
        return this.getResource(sanitized.getHrefWithoutQuery(), clazz, sanitized.getQuery());
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz, Criteria criteria) {
        Assert.isInstanceOf(DefaultCriteria.class, (Object)criteria, (String)("The " + this.getClass().getName() + " implementation only functions with " + DefaultCriteria.class.getName() + " instances."));
        DefaultCriteria dc = (DefaultCriteria)criteria;
        QueryString qs = this.queryStringFactory.createQueryString(href, dc);
        return this.getResource(href, clazz, qs);
    }

    private <T extends Resource> T getResource(String href, Class<T> clazz, QueryString qs) {
        Request request;
        href = this.ensureFullyQualified(href);
        Map<String, Object> data = null;
        if (this.isCacheRetrievalEnabled(clazz)) {
            data = this.getCachedValue(href, clazz);
        }
        if (Collections.isEmpty(data) && !Collections.isEmpty(data = this.executeRequest(request = this.createRequest(HttpMethod.GET, href, qs))) && this.isCacheUpdateEnabled(clazz)) {
            this.cache(clazz, data);
        }
        if (CollectionResource.class.isAssignableFrom(clazz)) {
            return this.resourceFactory.instantiate(clazz, data, qs);
        }
        return this.resourceFactory.instantiate(clazz, data);
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource) {
        Class<?> clazz = resource.getClass();
        Object returnValue = this.create(parentHref, resource, clazz);
        AbstractResource in = (AbstractResource)resource;
        AbstractResource ret = (AbstractResource)returnValue;
        LinkedHashMap<String, Object> props = this.toMap(ret, false);
        in.setProperties(props);
        return (T)in;
    }

    @Override
    public <T extends Resource> T create(String parentHref, T resource, Options options) {
        Assert.isInstanceOf(DefaultOptions.class, (Object)options, (String)("The " + this.getClass().getName() + " implementation only functions with " + DefaultOptions.class.getName() + " instances."));
        DefaultOptions defaultOptions = (DefaultOptions)options;
        QueryString qs = this.queryStringFactory.createQueryString(parentHref, defaultOptions);
        Class<?> clazz = resource.getClass();
        Object returnValue = this.save(parentHref, resource, clazz, qs);
        AbstractResource in = (AbstractResource)resource;
        AbstractResource ret = (AbstractResource)returnValue;
        LinkedHashMap<String, Object> props = this.toMap(ret, false);
        in.setProperties(props);
        return (T)in;
    }

    @Override
    public <T extends Resource & Saveable> void save(T resource) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        Assert.isInstanceOf(Saveable.class, resource);
        AbstractResource aResource = (AbstractResource)resource;
        String href = aResource.getHref();
        Assert.hasLength((String)href, (String)"'save' may only be called on objects that have already been persisted and have an existing href attribute.");
        Class<?> clazz = resource.getClass();
        Object returnValue = this.save(href, resource, clazz);
        AbstractResource ret = (AbstractResource)returnValue;
        LinkedHashMap<String, Object> props = this.toMap(ret, false);
        aResource.setProperties(props);
    }

    @Override
    public <T extends Resource & Saveable> void save(T resource, Options options) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        Assert.isInstanceOf(Saveable.class, resource);
        Assert.isInstanceOf(DefaultOptions.class, (Object)options, (String)("The " + this.getClass().getName() + " implementation only functions with " + DefaultOptions.class.getName() + " instances."));
        AbstractResource aResource = (AbstractResource)resource;
        String href = aResource.getHref();
        Assert.hasLength((String)href, (String)"'save' may only be called on objects that have already been persisted and have an existing href attribute.");
        DefaultOptions defaultOptions = (DefaultOptions)options;
        QueryString qs = this.queryStringFactory.createQueryString(href, defaultOptions);
        Class<?> clazz = resource.getClass();
        Object returnValue = this.save(href, resource, clazz, qs);
        AbstractResource ret = (AbstractResource)returnValue;
        LinkedHashMap<String, Object> props = this.toMap(ret, false);
        aResource.setProperties(props);
    }

    @Override
    public <T extends Resource, R extends Resource> R create(String parentHref, T resource, Class<? extends R> returnType) {
        return this.save(parentHref, resource, returnType);
    }

    @Override
    public <T extends Resource & Saveable, R extends Resource> R save(T resource, Class<? extends R> returnType) {
        return this.save(resource.getHref(), resource, returnType);
    }

    private <T extends Resource, R extends Resource> R save(String href, T resource, Class<? extends R> returnType) {
        return this.save(href, resource, returnType, null);
    }

    private <T extends Resource, R extends Resource> R save(String href, T resource, Class<? extends R> returnType, QueryString queryString) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.notNull(returnType, (String)"returnType class cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        href = this.ensureFullyQualified(href);
        AbstractResource abstractResource = (AbstractResource)resource;
        LinkedHashMap<String, Object> props = this.toMap(abstractResource, true);
        String bodyString = this.mapMarshaller.marshal(props);
        StringInputStream body = new StringInputStream(bodyString);
        long length = body.available();
        DefaultRequest request = new DefaultRequest(HttpMethod.POST, href, queryString, null, body, length);
        Map<String, Object> responseBody = this.executeRequest(request);
        if (Collections.isEmpty(responseBody)) {
            return null;
        }
        assert (responseBody != null && !responseBody.isEmpty()) : "Response body must be non-empty.";
        if (this.isCacheUpdateEnabled(returnType)) {
            this.cache(returnType, responseBody);
        }
        return this.resourceFactory.instantiate(returnType, responseBody);
    }

    @Override
    public <T extends Resource> void delete(T resource) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        AbstractResource abstractResource = (AbstractResource)resource;
        String href = abstractResource.getHref();
        this.uncache(abstractResource);
        Request request = this.createRequest(HttpMethod.DELETE, href, null);
        this.executeRequest(request);
    }

    @Override
    public <T extends Resource> void deleteResourceProperty(T resource, String propertyName) {
        Assert.notNull(resource, (String)"resource argument cannot be null.");
        Assert.isInstanceOf(AbstractResource.class, resource);
        Assert.hasText((String)propertyName, (String)"propertyName cannot be null or empty.");
        AbstractResource abstractResource = (AbstractResource)resource;
        String href = abstractResource.getHref();
        href = href + "/" + propertyName;
        this.uncache(abstractResource);
        Request request = this.createRequest(HttpMethod.DELETE, href, null);
        this.executeRequest(request);
    }

    protected boolean isCachingEnabled() {
        return this.cacheManager != null && !(this.cacheManager instanceof DisabledCacheManager);
    }

    private <T extends Resource> boolean isCacheRetrievalEnabled(Class<T> clazz) {
        return this.isCachingEnabled() && !CollectionResource.class.isAssignableFrom(clazz);
    }

    private <T extends Resource> boolean isCacheUpdateEnabled(Class<T> clazz) {
        return this.isCachingEnabled();
    }

    private boolean isDirectlyCacheable(Class<? extends Resource> clazz, Map<String, ?> data) {
        return this.isCachingEnabled() && !Collections.isEmpty(data) && data.get("href") != null && !CollectionResource.class.isAssignableFrom(clazz);
    }

    private void cache(Class<? extends Resource> clazz, Map<String, ?> data) {
        if (!this.isCachingEnabled()) {
            return;
        }
        Assert.notEmpty(data, (String)"Resource data cannot be null or empty.");
        String href = (String)data.get("href");
        if (this.isDirectlyCacheable(clazz, data)) {
            Assert.notNull((Object)href, (String)"Resource data must contain an 'href' attribute.");
            Assert.isTrue((data.size() > 1 ? 1 : 0) != 0, (String)"Resource data must be materialized to be cached (need more than just an 'href' attribute).");
        }
        LinkedHashMap toCache = new LinkedHashMap(data.size());
        if (CustomData.class.isAssignableFrom(clazz)) {
            toCache.putAll(data);
            Cache<String, Map<String, ?>> cache = this.getCache(clazz);
            cache.put((Object)href, toCache);
            return;
        }
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map nested = (Map)value;
                Assert.notEmpty((Map)nested, (String)"Resource references are expected to be complex objects with at least an 'href' property.");
                Assert.notNull(nested.get("href"), (String)"Resource references must have an 'href' attribute.");
                if (this.isMaterialized(nested)) {
                    Property property = this.getPropertyDescriptor(clazz, name);
                    Assert.isTrue((boolean)(property instanceof ResourceReference), (String)"It is expected that only ResourceReference properties are complex objects.");
                    this.cache(property.getType(), nested);
                    value = this.referenceFactory.createReference(name, nested);
                }
            } else if (value instanceof Collection) {
                Collection c = (Collection)value;
                ArrayList list = new ArrayList(c.size());
                Property property = this.getPropertyDescriptor(clazz, name);
                Assert.isTrue((boolean)(property instanceof ArrayProperty), (String)"It is expected that only ArrayProperty properties represent collection items.");
                ArrayProperty itemsProperty = (ArrayProperty)ArrayProperty.class.cast(property);
                Class itemType = itemsProperty.getType();
                Iterator i$ = c.iterator();
                while (i$.hasNext()) {
                    Map referenceData;
                    Object o;
                    Object element = o = i$.next();
                    if (o instanceof Map && this.isMaterialized(referenceData = (Map)o)) {
                        this.cache(itemType, referenceData);
                        element = this.referenceFactory.createReference(referenceData);
                    }
                    list.add(element);
                }
                value = list;
            }
            if (DefaultAccount.PASSWORD.getName().equals(name)) continue;
            toCache.put(name, value);
        }
        if (this.isDirectlyCacheable(clazz, toCache)) {
            Cache<String, Map<String, ?>> cache = this.getCache(clazz);
            cache.put((Object)href, toCache);
        }
    }

    private boolean isMaterialized(Map<String, ?> props) {
        return props != null && props.get("href") != null && props.size() > 1;
    }

    private <T extends Resource> Property getPropertyDescriptor(Class<T> clazz, String propertyName) {
        Map<String, Property> descriptors = this.getPropertyDescriptors(clazz);
        return descriptors.get(propertyName);
    }

    private <T extends Resource> Map<String, Property> getPropertyDescriptors(Class<T> clazz) {
        Class<T> implClass = DefaultResourceFactory.getImplementationClass(clazz);
        try {
            Field field = implClass.getDeclaredField("PROPERTY_DESCRIPTORS");
            field.setAccessible(true);
            return (Map)field.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to access PROPERTY_DESCRIPTORS static field on implementation class " + clazz.getName(), e);
        }
    }

    private <T extends Resource> Map<String, ?> getCachedValue(String href, Class<T> clazz) {
        Assert.hasText((String)href, (String)"href argument cannot be null or empty.");
        Assert.notNull(clazz, (String)"Class argument cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(clazz);
        return (Map)cache.get((Object)href);
    }

    private <T extends Resource> void uncache(T resource) {
        Assert.notNull(resource, (String)"Resource argument cannot be null.");
        Cache<String, Map<String, ?>> cache = this.getCache(resource.getClass());
        String href = resource.getHref();
        cache.remove((Object)href);
    }

    private <T> Cache<String, Map<String, ?>> getCache(Class<T> clazz) {
        Assert.notNull(clazz, (String)"Class argument cannot be null.");
        String cacheRegionName = this.cacheRegionNameResolver.getCacheRegionName(clazz);
        return this.cacheManager.getCache(cacheRegionName);
    }

    private LinkedHashMap<String, Object> toMap(AbstractResource resource, boolean isUpdateMap) {
        Set<String> propNames = isUpdateMap ? resource.getUpdatedPropertyNames() : resource.getPropertyNames();
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(propNames.size());
        for (String propName : propNames) {
            Map<String, String> prop = resource.getProperty(propName);
            if (resource instanceof CustomData) {
                props.put(propName, prop);
                continue;
            }
            if (prop instanceof CustomData) {
                if (isUpdateMap) {
                    Assert.isInstanceOf(AbstractResource.class, (Object)prop);
                    AbstractResource customDataAbstractResource = (AbstractResource)((Object)prop);
                    LinkedHashMap<String, Object> customDataProperties = new LinkedHashMap<String, Object>(propNames.size());
                    for (String updatedCustomPropertyName : customDataAbstractResource.getUpdatedPropertyNames()) {
                        Object object = customDataAbstractResource.getProperty(updatedCustomPropertyName);
                        customDataProperties.put(updatedCustomPropertyName, object);
                    }
                    props.put(propName, customDataProperties);
                    continue;
                }
                props.put(propName, prop);
                continue;
            }
            if (prop instanceof Map) {
                prop = this.referenceFactory.createReference(propName, prop);
            } else if (prop instanceof Resource) {
                prop = this.referenceFactory.createReference(propName, (Resource)prop);
            }
            props.put(propName, prop);
        }
        return props;
    }

    private Request createRequest(HttpMethod method, String href, Map<String, ?> queryParams) {
        Assert.notNull((Object)href, (String)"href argument cannot be null.");
        href = this.ensureFullyQualified(href);
        QueryString qs = this.queryStringFactory.createQueryString(queryParams);
        return new DefaultRequest(method, href, qs);
    }

    private Map<String, Object> executeRequest(Request request) {
        this.applyDefaultRequestHeaders(request);
        Response response = this.requestExecutor.executeRequest(request);
        log.trace("Executed HTTP request.");
        String body = null;
        if (response.hasBody()) {
            body = DefaultDataStore.toString(response.getBody());
        }
        Map mapBody = null;
        if (body != null) {
            log.trace("Obtained response body: \n{}", (Object)body);
            mapBody = this.mapMarshaller.unmarshal(body);
        }
        if (response.isError()) {
            DefaultError error = new DefaultError(mapBody);
            throw new ResourceException((Error)error);
        }
        return mapBody;
    }

    protected void applyDefaultRequestHeaders(Request request) {
        request.getHeaders().setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        request.getHeaders().set("User-Agent", "Stormpath-JavaSDK/" + Version.getClientVersion());
        if (request.getBody() != null) {
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        }
    }

    protected String ensureFullyQualified(String href) {
        String value = href;
        if (!this.isFullyQualified(href)) {
            value = this.qualify(href);
        }
        return value;
    }

    protected boolean isFullyQualified(String href) {
        return href.toLowerCase().startsWith("http");
    }

    protected String qualify(String href) {
        StringBuilder sb = new StringBuilder(this.baseUrl);
        if (!href.startsWith("/")) {
            sb.append("/");
        }
        sb.append(href);
        return sb.toString();
    }

    private static String toString(InputStream is) {
        try {
            return new Scanner(is, "UTF-8").useDelimiter("\\A").next();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

