/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.application;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountCriteria;
import com.stormpath.sdk.account.AccountList;
import com.stormpath.sdk.account.Accounts;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.account.PasswordResetToken;
import com.stormpath.sdk.application.AccountStoreMapping;
import com.stormpath.sdk.application.AccountStoreMappingCriteria;
import com.stormpath.sdk.application.AccountStoreMappingList;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationStatus;
import com.stormpath.sdk.authc.AuthenticationRequest;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.group.CreateGroupRequest;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.group.GroupCriteria;
import com.stormpath.sdk.group.GroupList;
import com.stormpath.sdk.group.Groups;
import com.stormpath.sdk.impl.application.PasswordResetTokenList;
import com.stormpath.sdk.impl.authc.BasicAuthenticator;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.CollectionReference;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.impl.resource.StatusProperty;
import com.stormpath.sdk.impl.resource.StringProperty;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.query.Criteria;
import com.stormpath.sdk.query.Options;
import com.stormpath.sdk.resource.ResourceException;
import com.stormpath.sdk.tenant.Tenant;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplication
extends AbstractInstanceResource
implements Application {
    private static final Logger log = LoggerFactory.getLogger(DefaultApplication.class);
    static final StringProperty NAME = new StringProperty("name");
    static final StringProperty DESCRIPTION = new StringProperty("description");
    static final StatusProperty<ApplicationStatus> STATUS = new StatusProperty<ApplicationStatus>(ApplicationStatus.class);
    static final ResourceReference<Tenant> TENANT = new ResourceReference<Tenant>("tenant", Tenant.class);
    static final ResourceReference<AccountStoreMapping> DEFAULT_ACCOUNT_STORE_MAPPING = new ResourceReference<AccountStoreMapping>("defaultAccountStoreMapping", AccountStoreMapping.class);
    static final ResourceReference<AccountStoreMapping> DEFAULT_GROUP_STORE_MAPPING = new ResourceReference<AccountStoreMapping>("defaultGroupStoreMapping", AccountStoreMapping.class);
    static final CollectionReference<AccountList, Account> ACCOUNTS = new CollectionReference<AccountList, Account>("accounts", AccountList.class, Account.class);
    static final CollectionReference<GroupList, Group> GROUPS = new CollectionReference<GroupList, Group>("groups", GroupList.class, Group.class);
    static final CollectionReference<AccountStoreMappingList, AccountStoreMapping> ACCOUNT_STORE_MAPPINGS = new CollectionReference<AccountStoreMappingList, AccountStoreMapping>("accountStoreMappings", AccountStoreMappingList.class, AccountStoreMapping.class);
    static final CollectionReference<PasswordResetTokenList, PasswordResetToken> PASSWORD_RESET_TOKENS = new CollectionReference<PasswordResetTokenList, PasswordResetToken>("passwordResetTokens", PasswordResetTokenList.class, PasswordResetToken.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultApplication.createPropertyDescriptorMap(NAME, DESCRIPTION, STATUS, TENANT, DEFAULT_ACCOUNT_STORE_MAPPING, DEFAULT_GROUP_STORE_MAPPING, ACCOUNTS, GROUPS, ACCOUNT_STORE_MAPPINGS, PASSWORD_RESET_TOKENS);

    public DefaultApplication(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultApplication(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public String getName() {
        return this.getString(NAME);
    }

    public void setName(String name) {
        this.setProperty(NAME, (Object)name);
    }

    public String getDescription() {
        return this.getString(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.setProperty(DESCRIPTION, (Object)description);
    }

    public ApplicationStatus getStatus() {
        String value = this.getStringProperty(STATUS.getName());
        if (value == null) {
            return null;
        }
        return ApplicationStatus.valueOf((String)value.toUpperCase());
    }

    public void setStatus(ApplicationStatus status) {
        this.setProperty(STATUS, (Object)status.name());
    }

    public AccountList getAccounts() {
        return (AccountList)this.getResourceProperty(ACCOUNTS);
    }

    public AccountList getAccounts(Map<String, Object> queryParams) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, queryParams);
    }

    public AccountList getAccounts(AccountCriteria criteria) {
        AccountList list = this.getAccounts();
        return this.getDataStore().getResource(list.getHref(), AccountList.class, (Criteria)criteria);
    }

    public GroupList getGroups() {
        return (GroupList)this.getResourceProperty(GROUPS);
    }

    public GroupList getGroups(Map<String, Object> queryParams) {
        GroupList list = this.getGroups();
        return this.getDataStore().getResource(list.getHref(), GroupList.class, queryParams);
    }

    public GroupList getGroups(GroupCriteria criteria) {
        GroupList groups = this.getGroups();
        return this.getDataStore().getResource(groups.getHref(), GroupList.class, (Criteria)criteria);
    }

    public Tenant getTenant() {
        return this.getResourceProperty(TENANT);
    }

    public Account sendPasswordResetEmail(String accountUsernameOrEmail) {
        PasswordResetToken token = this.createPasswordResetToken(accountUsernameOrEmail);
        return token.getAccount();
    }

    private PasswordResetToken createPasswordResetToken(String email) {
        String href = this.getPasswordResetTokensHref();
        PasswordResetToken passwordResetToken = (PasswordResetToken)this.getDataStore().instantiate(PasswordResetToken.class);
        passwordResetToken.setEmail(email);
        return this.getDataStore().create(href, passwordResetToken);
    }

    private String getPasswordResetTokensHref() {
        Map passwordResetTokensLink = (Map)this.getProperty(PASSWORD_RESET_TOKENS.getName());
        return (String)passwordResetTokensLink.get("href");
    }

    public Account verifyPasswordResetToken(String token) {
        String href = this.getPasswordResetTokensHref() + "/" + token;
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(1);
        props.put("href", href);
        PasswordResetToken prToken = this.getDataStore().instantiate(PasswordResetToken.class, props);
        return prToken.getAccount();
    }

    public AuthenticationResult authenticateAccount(AuthenticationRequest request) {
        return new BasicAuthenticator(this.getDataStore()).authenticate(this.getHref(), request);
    }

    public Group createGroup(Group group) {
        Assert.notNull((Object)group, (String)"Group instance cannot be null.");
        CreateGroupRequest request = Groups.newCreateRequestFor((Group)group).build();
        return this.createGroup(request);
    }

    public Group createGroup(CreateGroupRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Group group = request.getGroup();
        String href = this.getGroups().getHref();
        if (request.isGroupOptionsSpecified()) {
            return this.getDataStore().create(href, group, (Options)request.getGroupOptions());
        }
        return this.getDataStore().create(href, group);
    }

    public Account createAccount(Account account) {
        Assert.notNull((Object)account, (String)"Account instance cannot be null.");
        CreateAccountRequest request = Accounts.newCreateRequestFor((Account)account).build();
        return this.createAccount(request);
    }

    public Account createAccount(CreateAccountRequest request) {
        Assert.notNull((Object)request, (String)"Request cannot be null.");
        Account account = request.getAccount();
        String href = this.getAccounts().getHref();
        if (request.isRegistrationWorkflowOptionSpecified()) {
            href = href + "?registrationWorkflowEnabled=" + request.isRegistrationWorkflowEnabled();
        }
        if (request.isAccountOptionsSpecified()) {
            return this.getDataStore().create(href, account, (Options)request.getAccountOptions());
        }
        return this.getDataStore().create(href, account);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }

    public AccountStoreMappingList getAccountStoreMappings() {
        return (AccountStoreMappingList)this.getResourceProperty(ACCOUNT_STORE_MAPPINGS);
    }

    public AccountStoreMappingList getAccountStoreMappings(Map<String, Object> queryParams) {
        AccountStoreMappingList accountStoreMappings = this.getAccountStoreMappings();
        return this.getDataStore().getResource(accountStoreMappings.getHref(), AccountStoreMappingList.class, queryParams);
    }

    public AccountStoreMappingList getAccountStoreMappings(AccountStoreMappingCriteria criteria) {
        AccountStoreMappingList accountStoreMappings = this.getAccountStoreMappings();
        return this.getDataStore().getResource(accountStoreMappings.getHref(), AccountStoreMappingList.class, (Criteria)criteria);
    }

    public AccountStore getDefaultAccountStore() {
        AccountStoreMapping accountStoreMap = this.getResourceProperty(DEFAULT_ACCOUNT_STORE_MAPPING);
        return accountStoreMap == null ? null : accountStoreMap.getAccountStore();
    }

    public void setDefaultAccountStore(AccountStore accountStore) {
        AccountStoreMappingList accountStoreMappingList = this.getAccountStoreMappings();
        boolean needToCreateNewStore = true;
        for (AccountStoreMapping accountStoreMapping : accountStoreMappingList) {
            if (!accountStoreMapping.getAccountStore().getHref().equals(accountStore.getHref())) continue;
            needToCreateNewStore = false;
            accountStoreMapping.setDefaultAccountStore(true);
            accountStoreMapping.save();
            break;
        }
        if (needToCreateNewStore) {
            AccountStoreMapping mapping = this.addAccountStore(accountStore);
            mapping.setDefaultAccountStore(true);
            mapping.save();
        }
    }

    public AccountStore getDefaultGroupStore() {
        AccountStoreMapping accountStoreMap = this.getResourceProperty(DEFAULT_GROUP_STORE_MAPPING);
        return accountStoreMap == null ? null : accountStoreMap.getAccountStore();
    }

    public void setDefaultGroupStore(AccountStore accountStore) {
        AccountStoreMappingList accountStoreMappingList = this.getAccountStoreMappings();
        boolean needToCreateNewStore = true;
        for (AccountStoreMapping accountStoreMapping : accountStoreMappingList) {
            if (!accountStoreMapping.getAccountStore().getHref().equals(accountStore.getHref())) continue;
            needToCreateNewStore = false;
            accountStoreMapping.setDefaultGroupStore(true);
            accountStoreMapping.save();
            break;
        }
        if (needToCreateNewStore) {
            AccountStoreMapping mapping = this.addAccountStore(accountStore);
            mapping.setDefaultGroupStore(true);
            mapping.save();
        }
    }

    public AccountStoreMapping createAccountStoreMapping(AccountStoreMapping mapping) throws ResourceException {
        String href = this.getAccountStoreMappingsHref();
        return this.getDataStore().create(href, mapping);
    }

    public AccountStoreMapping addAccountStore(AccountStore accountStore) throws ResourceException {
        AccountStoreMapping accountStoreMapping = (AccountStoreMapping)this.getDataStore().instantiate(AccountStoreMapping.class);
        accountStoreMapping.setAccountStore(accountStore);
        accountStoreMapping.setApplication((Application)this);
        accountStoreMapping.setListIndex(Integer.MAX_VALUE);
        return this.createAccountStoreMapping(accountStoreMapping);
    }

    private String getAccountStoreMappingsHref() {
        String href = "/accountStoreMappings";
        return href;
    }
}

