/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.application;

import com.stormpath.sdk.application.AccountStoreMapping;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.impl.ds.InternalDataStore;
import com.stormpath.sdk.impl.resource.AbstractInstanceResource;
import com.stormpath.sdk.impl.resource.BooleanProperty;
import com.stormpath.sdk.impl.resource.IntegerProperty;
import com.stormpath.sdk.impl.resource.Property;
import com.stormpath.sdk.impl.resource.ResourceReference;
import com.stormpath.sdk.resource.Resource;
import java.util.Map;

public class DefaultAccountStoreMapping
extends AbstractInstanceResource
implements AccountStoreMapping {
    static final IntegerProperty LIST_INDEX = new IntegerProperty("listIndex");
    static final BooleanProperty DEFAULT_ACCOUNT_STORE = new BooleanProperty("isDefaultAccountStore");
    static final BooleanProperty DEFAULT_GROUP_STORE = new BooleanProperty("isDefaultGroupStore");
    static final ResourceReference<Application> APPLICATION = new ResourceReference<Application>("application", Application.class);
    static final ResourceReference<AccountStore> ACCOUNT_STORE = new ResourceReference<AccountStore>("accountStore", AccountStore.class);
    static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultAccountStoreMapping.createPropertyDescriptorMap(LIST_INDEX, DEFAULT_ACCOUNT_STORE, DEFAULT_GROUP_STORE, APPLICATION, ACCOUNT_STORE);

    public DefaultAccountStoreMapping(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultAccountStoreMapping(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Application getApplication() {
        return this.getResourceProperty(APPLICATION);
    }

    public void setApplication(Application application) {
        this.setResourceProperty(APPLICATION, (Resource)application);
    }

    public AccountStore getAccountStore() {
        String href = this.getAccountStoreHref();
        AccountStore accountStore = null;
        if (href.contains("directories")) {
            accountStore = (AccountStore)this.getDataStore().getResource(href, Directory.class);
        } else if (href.contains("groups")) {
            accountStore = (AccountStore)this.getDataStore().getResource(href, Group.class);
        }
        return accountStore;
    }

    private String getAccountStoreHref() {
        Map map = (Map)this.getProperty(ACCOUNT_STORE.getName());
        String href = null;
        if (map != null && !map.isEmpty()) {
            href = (String)map.get("href");
        }
        return href;
    }

    public void setAccountStore(AccountStore accountStore) {
        this.setResourceProperty(ACCOUNT_STORE, (Resource)accountStore);
    }

    public int getListIndex() {
        return this.getInt(LIST_INDEX);
    }

    public void setListIndex(int listIndex) {
        this.setProperty(LIST_INDEX, (Object)listIndex);
    }

    public boolean isDefaultAccountStore() {
        return this.getBoolean(DEFAULT_ACCOUNT_STORE);
    }

    public void setDefaultAccountStore(boolean defaultAccountStore) {
        this.setProperty(DEFAULT_ACCOUNT_STORE, (Object)defaultAccountStore);
    }

    public void setDefaultGroupStore(boolean defaultGroupStore) {
        this.setProperty(DEFAULT_GROUP_STORE, (Object)defaultGroupStore);
    }

    public boolean isDefaultGroupStore() {
        return this.getBoolean(DEFAULT_GROUP_STORE);
    }

    public void delete() {
        this.getDataStore().delete(this);
    }
}

