/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.impl.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.account.AccountOptions;
import com.stormpath.sdk.account.CreateAccountRequest;
import com.stormpath.sdk.account.CreateAccountRequestBuilder;
import com.stormpath.sdk.impl.account.DefaultCreateAccountRequest;
import com.stormpath.sdk.lang.Assert;

public class DefaultCreateAccountRequestBuilder
implements CreateAccountRequestBuilder {
    private Account account;
    private Boolean registrationWorkflowEnabled;
    private AccountOptions options;

    public DefaultCreateAccountRequestBuilder(Account account) {
        Assert.notNull((Object)account, (String)"Account cannot be null.");
        this.account = account;
    }

    public CreateAccountRequestBuilder setRegistrationWorkflowEnabled(boolean registrationWorkflowEnabled) {
        this.registrationWorkflowEnabled = registrationWorkflowEnabled;
        return this;
    }

    public CreateAccountRequestBuilder withResponseOptions(AccountOptions options) {
        Assert.notNull((Object)options);
        this.options = options;
        return this;
    }

    public CreateAccountRequest build() {
        return new DefaultCreateAccountRequest(this.account, this.registrationWorkflowEnabled, this.options);
    }
}

