/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.client;

import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.client.ApiKey;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.client.DefaultApiKey;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.lang.Classes;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;

public class ClientBuilder {
    private ApiKey apiKey;
    private String apiKeyFileLocation;
    private InputStream apiKeyInputStream;
    private Reader apiKeyReader;
    private Properties apiKeyProperties;
    private String apiKeyIdPropertyName = "apiKey.id";
    private String apiKeySecretPropertyName = "apiKey.secret";
    private String baseUrl = "https://api.stormpath.com/v1";
    private Proxy proxy;
    private CacheManager cacheManager;

    public ClientBuilder setApiKey(String apiKeyId, String apiKeySecret) {
        DefaultApiKey apiKey = new DefaultApiKey(apiKeyId, apiKeySecret);
        return this.setApiKey(apiKey);
    }

    public ClientBuilder setApiKey(ApiKey apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ClientBuilder setApiKeyProperties(Properties properties) {
        this.apiKeyProperties = properties;
        return this;
    }

    public ClientBuilder setApiKeyReader(Reader reader) {
        this.apiKeyReader = reader;
        return this;
    }

    public ClientBuilder setApiKeyInputStream(InputStream is) {
        this.apiKeyInputStream = is;
        return this;
    }

    public ClientBuilder setApiKeyFileLocation(String location) {
        this.apiKeyFileLocation = location;
        return this;
    }

    public ClientBuilder setApiKeyIdPropertyName(String apiKeyIdPropertyName) {
        this.apiKeyIdPropertyName = apiKeyIdPropertyName;
        return this;
    }

    public ClientBuilder setApiKeySecretPropertyName(String apiKeySecretPropertyName) {
        this.apiKeySecretPropertyName = apiKeySecretPropertyName;
        return this;
    }

    public ClientBuilder setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy argument cannot be null.");
        }
        this.proxy = proxy;
        return this;
    }

    public ClientBuilder setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        return this;
    }

    ClientBuilder setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public Client build() {
        ApiKey apiKey = this.apiKey;
        if (apiKey == null) {
            apiKey = this.loadApiKey();
        }
        return new Client(apiKey, this.baseUrl, this.proxy, this.cacheManager);
    }

    protected ApiKey loadApiKey() {
        Properties properties = this.loadApiKeyProperties();
        String apiKeyId = this.getRequiredPropertyValue(properties, this.apiKeyIdPropertyName, "apiKeyId");
        String apiKeySecret = this.getRequiredPropertyValue(properties, this.apiKeySecretPropertyName, "apiKeySecret");
        return this.createApiKey(apiKeyId, apiKeySecret);
    }

    protected Properties loadApiKeyProperties() {
        Properties properties = this.apiKeyProperties;
        if (properties == null || properties.isEmpty()) {
            Reader reader = this.getAvailableReader();
            if (reader == null) {
                String msg = "No API Key properties could be found or loaded from a file location.  Please configure the 'apiKeyFileLocation' property or alternatively configure a Properties, Reader or InputStream instance.";
                throw new IllegalArgumentException(msg);
            }
            properties = new Properties();
            try {
                properties.load(reader);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to load apiKey properties file.", e);
            }
        }
        return properties;
    }

    protected ApiKey createApiKey(String id, String secret) {
        return new DefaultApiKey(id, secret);
    }

    private String getPropertyValue(Properties properties, String propName) {
        String value = properties.getProperty(propName);
        if (value != null && "".equals(value = value.trim())) {
            value = null;
        }
        return value;
    }

    private String getRequiredPropertyValue(Properties props, String propName, String masterName) {
        String value = this.getPropertyValue(props, propName);
        if (value == null) {
            String msg = "There is no '" + propName + "' property in the " + "configured apiKey properties.  You can either specify that property or " + "configure the " + masterName + "PropertyName value on the ClientBuilder to specify a " + "custom property name.";
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    private Reader getAvailableReader() {
        if (this.apiKeyReader != null) {
            return this.apiKeyReader;
        }
        InputStream is = this.apiKeyInputStream;
        if (is == null && this.apiKeyFileLocation != null) {
            try {
                is = ResourceUtils.getInputStreamForPath(this.apiKeyFileLocation);
            }
            catch (IOException e) {
                String msg = "Unable to load API Key using apiKeyFileLocation '" + this.apiKeyFileLocation + "'.  " + "Please check and ensure that file exists or use the 'setApiKeyFileLocation' method to specify " + "a valid location.";
                throw new IllegalStateException(msg, e);
            }
        }
        if (is != null) {
            return this.toReader(is);
        }
        return null;
    }

    private Reader toReader(InputStream is) {
        try {
            return new InputStreamReader(is, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ISO-8859-1 character set is not available on the current JVM.  This is required to read a Java-compatible Properties file. ", e);
        }
    }

    private static class ResourceUtils {
        public static final String CLASSPATH_PREFIX = "classpath:";
        public static final String URL_PREFIX = "url:";
        public static final String FILE_PREFIX = "file:";

        private ResourceUtils() {
        }

        public static boolean hasResourcePrefix(String resourcePath) {
            return resourcePath != null && (resourcePath.startsWith(CLASSPATH_PREFIX) || resourcePath.startsWith(URL_PREFIX) || resourcePath.startsWith(FILE_PREFIX));
        }

        public static InputStream getInputStreamForPath(String resourcePath) throws IOException {
            InputStream is = resourcePath.startsWith(CLASSPATH_PREFIX) ? ResourceUtils.loadFromClassPath(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(URL_PREFIX) ? ResourceUtils.loadFromUrl(ResourceUtils.stripPrefix(resourcePath)) : (resourcePath.startsWith(FILE_PREFIX) ? ResourceUtils.loadFromFile(ResourceUtils.stripPrefix(resourcePath)) : ResourceUtils.loadFromFile(resourcePath)));
            if (is == null) {
                throw new IOException("Resource [" + resourcePath + "] could not be found.");
            }
            return is;
        }

        private static InputStream loadFromFile(String path) throws IOException {
            return new FileInputStream(path);
        }

        private static InputStream loadFromUrl(String urlPath) throws IOException {
            URL url = new URL(urlPath);
            return url.openStream();
        }

        private static InputStream loadFromClassPath(String path) {
            return Classes.getResourceAsStream(path);
        }

        private static String stripPrefix(String resourcePath) {
            return resourcePath.substring(resourcePath.indexOf(":") + 1);
        }
    }
}

