/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.client;

import com.stormpath.sdk.cache.CacheManager;
import com.stormpath.sdk.client.ApiKey;
import com.stormpath.sdk.client.Proxy;
import com.stormpath.sdk.ds.DataStore;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Classes;
import com.stormpath.sdk.resource.Resource;
import com.stormpath.sdk.tenant.Tenant;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Client
implements DataStore {
    public static final int DEFAULT_API_VERSION = 1;
    private final DataStore dataStore;
    private String currentTenantHref;

    public Client(ApiKey apiKey) {
        if (apiKey == null) {
            throw new IllegalArgumentException("apiKey argument cannot be null.");
        }
        Object requestExecutor = this.createRequestExecutor(apiKey, null);
        this.dataStore = this.createDataStore(requestExecutor, 1);
    }

    public Client(ApiKey apiKey, Proxy proxy) {
        if (apiKey == null) {
            throw new IllegalArgumentException("apiKey argument cannot be null.");
        }
        if (proxy == null) {
            throw new IllegalArgumentException("proxy argument cannot be null.");
        }
        Object requestExecutor = this.createRequestExecutor(apiKey, proxy);
        this.dataStore = this.createDataStore(requestExecutor, 1);
    }

    Client(ApiKey apiKey, String baseUrl) {
        if (apiKey == null) {
            throw new IllegalArgumentException("apiKey argument cannot be null.");
        }
        Object requestExecutor = this.createRequestExecutor(apiKey, null);
        this.dataStore = this.createDataStore(requestExecutor, baseUrl);
    }

    Client(ApiKey apiKey, String baseUrl, Proxy proxy, CacheManager cacheManager) {
        Assert.notNull(apiKey, "apiKey argument cannot be null.");
        Object requestExecutor = this.createRequestExecutor(apiKey, proxy);
        DataStore ds = this.createDataStore(requestExecutor, baseUrl);
        if (cacheManager != null) {
            this.applyCacheManager(ds, cacheManager);
        }
        this.dataStore = ds;
    }

    private void applyCacheManager(DataStore dataStore, CacheManager cacheManager) {
        Class<?> clazz = dataStore.getClass();
        try {
            Method method = clazz.getDeclaredMethod("setCacheManager", CacheManager.class);
            method.setAccessible(true);
            method.invoke((Object)dataStore, cacheManager);
        }
        catch (Exception e) {
            String msg = "Unable to apply cacheManager instance on DataStore implementation " + clazz;
            throw new RuntimeException(msg);
        }
    }

    public Tenant getCurrentTenant() {
        String href = this.currentTenantHref;
        if (href == null) {
            href = "/tenants/current";
        }
        Tenant current = this.dataStore.getResource(href, Tenant.class);
        this.currentTenantHref = current.getHref();
        return current;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    private Object createRequestExecutor(ApiKey apiKey, Proxy proxy) {
        String className = "com.stormpath.sdk.impl.http.httpclient.HttpClientRequestExecutor";
        if (!Classes.isAvailable(className)) {
            String msg = "Unable to find the '" + className + "' implementation on the classpath.  Please ensure you " + "have added the stormpath-sdk-impl-httpclient .jar file to your runtime classpath.";
            throw new RuntimeException(msg);
        }
        Class requestExecutorClass = Classes.forName(className);
        Constructor ctor = Classes.getConstructor(requestExecutorClass, ApiKey.class, Proxy.class);
        return Classes.instantiate(ctor, apiKey, proxy);
    }

    private DataStore createDataStore(Object requestExecutor, Object secondCtorArg) {
        Class dataStoreClass;
        Class requestExecutorInterfaceClass;
        String requestExecutorInterfaceClassName = "com.stormpath.sdk.impl.http.RequestExecutor";
        try {
            requestExecutorInterfaceClass = Classes.forName(requestExecutorInterfaceClassName);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load required interface: " + requestExecutorInterfaceClassName + ".  Please ensure you have added the stormpath-sdk-impl .jar file to your runtime classpath.", t);
        }
        String className = "com.stormpath.sdk.impl.ds.DefaultDataStore";
        try {
            dataStoreClass = Classes.forName(className);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to load default DataStore implementation class: " + className + ".  Please ensure you have added the stormpath-sdk-impl .jar file to your " + "runtime classpath.", t);
        }
        Class<Object> secondCtorArgClass = secondCtorArg.getClass();
        if (Integer.class.equals(secondCtorArgClass)) {
            secondCtorArgClass = Integer.TYPE;
        }
        Constructor ctor = Classes.getConstructor(dataStoreClass, requestExecutorInterfaceClass, secondCtorArgClass);
        try {
            return (DataStore)ctor.newInstance(requestExecutor, secondCtorArg);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to instantiate DataStore implementation: " + className, t);
        }
    }

    @Override
    public <T extends Resource> T instantiate(Class<T> clazz) {
        return this.dataStore.instantiate(clazz);
    }

    @Override
    public <T extends Resource> T getResource(String href, Class<T> clazz) {
        return this.dataStore.getResource(href, clazz);
    }
}

