/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.contributors.AbstractXmlDocumentArtefactAnalyser;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import com.springsource.bundlor.util.ClassNameUtils;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JpaPersistenceArtefactAnalyser
extends AbstractXmlDocumentArtefactAnalyser {
    private final XPathExpression expression;

    public JpaPersistenceArtefactAnalyser() {
        super(false);
        try {
            XPathFactory newInstance = XPathFactory.newInstance();
            XPath xpath = newInstance.newXPath();
            this.expression = xpath.compile("//persistence-unit/provider | //persistence-unit/class");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    protected void analyse(Document doc, String artefactName, PartialManifest partialManifest) throws Exception {
        NodeList nodes = (NodeList)this.expression.evaluate(doc, XPathConstants.NODESET);
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            String candidateType = element.getTextContent().trim();
            if (ClassNameUtils.isValidFqn(candidateType)) {
                partialManifest.recordReferencedType(candidateType);
            }
            ++i;
        }
    }

    public boolean canAnalyse(String artefactName) {
        return "META-INF/persistence.xml".equals(artefactName);
    }
}

