/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.ManifestReader;
import com.springsource.bundlor.support.contributors.AbstractXmlConfigurationArtifactAnalyzer;
import com.springsource.bundlor.util.SimpleParserLogger;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import com.springsource.util.osgi.manifest.parse.HeaderParserFactory;
import com.springsource.util.osgi.manifest.parse.ParserLogger;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BlueprintArtifactAnalyzer
extends AbstractXmlConfigurationArtifactAnalyzer
implements ManifestReader {
    private static final String CLASS_ATTRIBUTES = "//bp:bean/bp:argument/@type | //bp:bean/@class | //bp:service/@interface | //bp:reference/@interface | //bp:reference-list/@interface | //bp:map/@key-type | //bp:map/@value-type | //bp:list/@value-type | //bp:set/@value-type | //bp:array/@value-type";
    private static final String CLASS_VALUES = "//bp:interfaces/bp:value";
    private static final Map<String, String> NAMESPACE_MAPPING = new HashMap<String, String>();
    private static final String DEFAULT_CONTEXT_LOCATION = "OSGI-INF/blueprint/*.xml";
    private static final String CONTEXT_PATH_HEADER = "Bundle-Blueprint";
    private final List<String> contextPaths = new ArrayList<String>();

    static {
        NAMESPACE_MAPPING.put("bp", "http://www.osgi.org/xmlns/blueprint/v1.0.0");
    }

    @Override
    public final void readJarManifest(ManifestContents manifest) {
        this.readContextPaths(manifest);
    }

    @Override
    public final void readManifestTemplate(ManifestContents manifestTemplate) {
        this.readContextPaths(manifestTemplate);
    }

    private final void readContextPaths(ManifestContents manifest) {
        String value = (String)manifest.getMainAttributes().get(CONTEXT_PATH_HEADER);
        List<HeaderDeclaration> headers = this.parseTemplate(value);
        if (headers.size() == 0) {
            this.contextPaths.add(DEFAULT_CONTEXT_LOCATION);
        } else {
            for (HeaderDeclaration header : headers) {
                this.contextPaths.add((String)header.getNames().get(0));
            }
        }
    }

    private final List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser((ParserLogger)new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }

    @Override
    public final boolean canAnalyse(String artefactName) {
        AntPathMatcher matcher = new AntPathMatcher();
        for (String contextPath : this.contextPaths) {
            if (!matcher.match(contextPath, artefactName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getClassAttributesXPathExpression() {
        return CLASS_ATTRIBUTES;
    }

    @Override
    protected String getClassValueXPathExpression() {
        return CLASS_VALUES;
    }

    @Override
    protected String getPackageXPathExpression() {
        return null;
    }

    @Override
    protected Map<String, String> getNamespaceMapping() {
        return NAMESPACE_MAPPING;
    }
}

