/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.maven.plugin.internal;

import com.springsource.bundlor.ClassPath;
import com.springsource.bundlor.ManifestGenerator;
import com.springsource.bundlor.ManifestWriter;
import com.springsource.bundlor.blint.ManifestValidator;
import com.springsource.bundlor.blint.support.DefaultManifestValidatorContributorsFactory;
import com.springsource.bundlor.blint.support.StandardManifestValidator;
import com.springsource.bundlor.maven.plugin.BundlorExecutor;
import com.springsource.bundlor.maven.plugin.internal.Configuration;
import com.springsource.bundlor.maven.plugin.internal.ConfigurationValidator;
import com.springsource.bundlor.maven.plugin.internal.ManifestTemplateFactory;
import com.springsource.bundlor.maven.plugin.internal.OsgiProfileFactory;
import com.springsource.bundlor.maven.plugin.internal.PropertiesSourceFactory;
import com.springsource.bundlor.support.DefaultManifestGeneratorContributorsFactory;
import com.springsource.bundlor.support.ManifestGeneratorContributors;
import com.springsource.bundlor.support.StandardManifestGenerator;
import com.springsource.bundlor.support.classpath.ClassPathFactory;
import com.springsource.bundlor.support.manifestwriter.ManifestWriterFactory;
import com.springsource.bundlor.support.properties.PropertiesSource;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenBundlorExecutor
implements BundlorExecutor {
    private final ClassPath inputClassPath;
    private final ManifestWriter manifestWriter;
    private final ManifestContents manifestTemplate;
    private final ManifestGenerator manifestGenerator;
    private final ManifestValidator manifestValidator;

    public MavenBundlorExecutor(Configuration configuration, ConfigurationValidator configurationValidator, ClassPathFactory classPathFactory, ManifestWriterFactory manifestWriterFactory, ManifestTemplateFactory manifestTemplateFactory, PropertiesSourceFactory propertiesSourceFactory, OsgiProfileFactory osgiProfileFactory) throws MojoExecutionException {
        configurationValidator.validate(configuration);
        this.inputClassPath = classPathFactory.create(configuration.getInputPath());
        this.manifestWriter = manifestWriterFactory.create(configuration.getInputPath(), configuration.getOutputPath());
        this.manifestTemplate = manifestTemplateFactory.create(configuration.getManifestTemplatePath(), configuration.getManifestTemplate(), configuration.getBundleSymbolicName(), configuration.getDefaultBundleSymbolicName(), configuration.getBundleVersion(), configuration.getDefaultBundleVersion());
        List<PropertiesSource> properties = propertiesSourceFactory.create(configuration.getPropertiesPath(), configuration.getProperties());
        properties.add(osgiProfileFactory.create(configuration.getOsgiProfilePath(), configuration.getOsgiProfile()));
        this.manifestGenerator = new StandardManifestGenerator(this.createContributors(properties));
        this.manifestValidator = new StandardManifestValidator(DefaultManifestValidatorContributorsFactory.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> execute() {
        ManifestContents manifest = this.manifestGenerator.generate(this.manifestTemplate, new ClassPath[]{this.inputClassPath});
        try {
            this.manifestWriter.write(manifest);
        }
        finally {
            this.manifestWriter.close();
        }
        return this.manifestValidator.validate(manifest);
    }

    private ManifestGeneratorContributors createContributors(List<PropertiesSource> properties) {
        return DefaultManifestGeneratorContributorsFactory.create((PropertiesSource[])properties.toArray(new PropertiesSource[properties.size()]));
    }
}

