/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.maven.plugin;

import com.springsource.bundlor.maven.plugin.BundlorExecutor;
import com.springsource.bundlor.maven.plugin.internal.Configuration;
import com.springsource.bundlor.maven.plugin.internal.MavenBundlorExecutor;
import com.springsource.bundlor.maven.plugin.internal.support.StandardConfigurationValidator;
import com.springsource.bundlor.maven.plugin.internal.support.StandardManifestTemplateFactory;
import com.springsource.bundlor.maven.plugin.internal.support.StandardOsgiProfileFactory;
import com.springsource.bundlor.maven.plugin.internal.support.StandardPropertiesSourceFactory;
import com.springsource.bundlor.support.classpath.ClassPathFactory;
import com.springsource.bundlor.support.classpath.StandardClassPathFactory;
import com.springsource.bundlor.support.manifestwriter.ManifestWriterFactory;
import com.springsource.bundlor.support.manifestwriter.StandardManifestWriterFactory;
import com.springsource.util.math.Sets;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.springframework.util.StringUtils;

public class BundlorMojo
extends AbstractMojo {
    private final Configuration configuration = new Configuration();
    private volatile boolean failOnWarnings = false;
    private volatile boolean enabled = true;
    private static final Set<String> IGNORED_PACKAGINGS = Sets.asSet((Object[])new String[]{"pom"});
    private volatile String packaging;
    private volatile String inputPath;
    private volatile String outputPath;
    private volatile String manifestTemplatePath;
    private volatile String manifestTemplate;
    private volatile String osgiProfilePath;
    private volatile String osgiProfile;
    private volatile String bundleSymbolicName;
    private volatile String defaultBundleSymbolicName;
    private volatile String bundleVersion;
    private volatile String defaultBundleVersion;
    private volatile String propertiesPath;
    private volatile Properties properties;
    private volatile String groupId;
    private volatile String artifactId;
    private volatile String version;

    public final void setFailOnWarnings(boolean failOnWarnings) {
        this.failOnWarnings = failOnWarnings;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public final void setInputPath(String inputPath) {
        this.configuration.setInputPath(inputPath);
    }

    public final void setOutputPath(String outputPath) {
        this.configuration.setOutputPath(outputPath);
    }

    public final void setManifestTemplatePath(String manifestTemplatePath) {
        this.configuration.setManifestTemplatePath(manifestTemplatePath);
    }

    public final void setManifestTemplate(String manifestTemplate) {
        this.configuration.setManifestTemplate(manifestTemplate);
    }

    public final void setOsgiProfilePath(String osgiProfilePath) {
        this.configuration.setOsgiProfilePath(osgiProfilePath);
    }

    public final void setOsgiProfile(String osgiProfile) {
        this.configuration.setOsgiProfile(osgiProfile);
    }

    public final void setBundleSymbolicName(String bundleSymbolicName) {
        this.configuration.setBundleSymbolicName(bundleSymbolicName);
    }

    public final void setDefaultBundleSymbolicName(String bundleSymbolicName) {
        this.configuration.setDefaultBundleSymbolicName(bundleSymbolicName);
    }

    public final void setBundleVersion(String bundleVersion) {
        this.configuration.setBundleVersion(bundleVersion);
    }

    public final void setDefaultBundleVersion(String bundleVersion) {
        this.configuration.setDefaultBundleVersion(bundleVersion);
    }

    public final void setPropertiesPath(String propertiesPath) {
        this.configuration.setPropertiesPath(propertiesPath);
    }

    public final void setProperties(Properties properties) {
        this.configuration.addProperties(properties);
    }

    public final void execute() throws MojoExecutionException {
        if (!this.enabled) {
            this.getLog().info((CharSequence)"Ignored project with enabled = false");
            return;
        }
        if (IGNORED_PACKAGINGS.contains(this.packaging)) {
            this.getLog().info((CharSequence)String.format("Ignored project with type = '%s'", this.packaging));
            return;
        }
        this.configuration.addProperties(this.createCommonProperties());
        List<String> warnings = this.getBundlorExecutor().execute();
        if (warnings.size() > 0) {
            this.getLog().warn((CharSequence)"Bundlor Warnings:");
            for (String warning : warnings) {
                this.getLog().warn((CharSequence)("    " + warning));
            }
            if (this.failOnWarnings) {
                String message = StringUtils.hasText((String)this.configuration.getManifestTemplatePath()) ? String.format("Bundlor returned warnings.  Please fix manifest template at '%s' and try again.", this.configuration.getManifestTemplatePath()) : "Bundlor returned warnings.  Please fix inline manifest template and try again.";
                throw new MojoExecutionException(message);
            }
        }
    }

    protected BundlorExecutor getBundlorExecutor() throws MojoExecutionException {
        return new MavenBundlorExecutor(this.configuration, new StandardConfigurationValidator(), (ClassPathFactory)new StandardClassPathFactory(), (ManifestWriterFactory)new StandardManifestWriterFactory(), new StandardManifestTemplateFactory(), new StandardPropertiesSourceFactory(), new StandardOsgiProfileFactory());
    }

    private Properties createCommonProperties() {
        Properties p = new Properties();
        if (this.groupId != null) {
            p.put("pom.groupId", this.groupId);
            p.put("project.groupId", this.groupId);
        }
        if (this.artifactId != null) {
            p.put("pom.artifactId", this.artifactId);
            p.put("project.artifactId", this.artifactId);
            p.put("project.name", this.artifactId);
        }
        if (this.version != null) {
            p.put("pom.version", this.version);
            p.put("project.version", this.version);
            p.put("version", this.version);
        }
        return p;
    }
}

