/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.commandline.internal.support;

import com.springsource.bundlor.commandline.internal.Configuration;
import com.springsource.bundlor.commandline.internal.ConfigurationValidator;
import java.io.File;
import org.springframework.util.StringUtils;

public final class StandardConfigurationValidator
implements ConfigurationValidator {
    public void validate(Configuration configuration) {
        this.inputPath(configuration.getInputPath());
        this.outputPath(configuration.getOutputPath());
        this.manifestTemplatePath(configuration.getManifestTemplatePath());
        this.osgiProfilePath(configuration.getOsgiProfilePath());
        this.propertiesPath(configuration.getPropertiesPath());
    }

    void inputPath(String inputPath) {
        if (!StringUtils.hasText((String)inputPath)) {
            throw new RuntimeException("Input path is required");
        }
        File inputFile = new File(inputPath);
        if (!inputFile.exists()) {
            throw new RuntimeException(String.format("Input path '%s' does not exist", inputPath));
        }
        if (inputFile.isDirectory()) {
            return;
        }
        if (inputFile.getAbsolutePath().endsWith("jar")) {
            return;
        }
        if (inputFile.getAbsolutePath().endsWith("war")) {
            return;
        }
        throw new RuntimeException(String.format("Input path '%s' is not JAR, WAR, or directory", inputPath));
    }

    void outputPath(String outputPath) {
        if (StringUtils.hasText((String)outputPath)) {
            File outputFile = new File(outputPath);
            if (outputFile.isDirectory()) {
                return;
            }
            if (!outputFile.getParentFile().exists()) {
                throw new RuntimeException(String.format("Output path's parent directory '%s' does not exist", outputFile.getParent()));
            }
            if (outputFile.getAbsolutePath().endsWith("jar")) {
                return;
            }
            if (outputFile.getAbsolutePath().endsWith("war")) {
                return;
            }
            throw new RuntimeException(String.format("Output path '%s' is not JAR, WAR, or directory", outputFile));
        }
    }

    void manifestTemplatePath(String manifestTemplatePath) {
        if (StringUtils.hasText((String)manifestTemplatePath)) {
            File manifestTemplateFile = new File(manifestTemplatePath);
            if (!manifestTemplateFile.exists()) {
                throw new RuntimeException(String.format("Manifest template path '%s' does not exist", manifestTemplatePath));
            }
            if (!manifestTemplateFile.isFile()) {
                throw new RuntimeException(String.format("Manifest template path '%s' must be a file", manifestTemplatePath));
            }
        }
    }

    void osgiProfilePath(String osgiProfilePath) {
        if (StringUtils.hasText((String)osgiProfilePath)) {
            File osgiProfileFile = new File(osgiProfilePath);
            if (!osgiProfileFile.exists()) {
                throw new RuntimeException(String.format("OSGi profile path '%s' does not exist", osgiProfilePath));
            }
            if (!osgiProfileFile.isFile()) {
                throw new RuntimeException(String.format("OSGi profile path '%s' must be a file", osgiProfilePath));
            }
        }
    }

    void propertiesPath(String propertiesPath) {
        if (StringUtils.hasText((String)propertiesPath)) {
            File propertiesFile = new File(propertiesPath);
            if (!propertiesFile.exists()) {
                throw new RuntimeException(String.format("Properties path '%s' does not exist", propertiesPath));
            }
            if (!propertiesFile.isFile()) {
                throw new RuntimeException(String.format("Properties path '%s' must be a file", propertiesPath));
            }
        }
    }
}

