/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.commandline.internal;

import com.springsource.bundlor.ClassPath;
import com.springsource.bundlor.ManifestGenerator;
import com.springsource.bundlor.ManifestWriter;
import com.springsource.bundlor.blint.ManifestValidator;
import com.springsource.bundlor.blint.support.DefaultManifestValidatorContributorsFactory;
import com.springsource.bundlor.blint.support.StandardManifestValidator;
import com.springsource.bundlor.commandline.BundlorExecutor;
import com.springsource.bundlor.commandline.internal.Configuration;
import com.springsource.bundlor.commandline.internal.ConfigurationValidator;
import com.springsource.bundlor.commandline.internal.ManifestTemplateFactory;
import com.springsource.bundlor.commandline.internal.OsgiProfileFactory;
import com.springsource.bundlor.commandline.internal.PropertiesSourceFactory;
import com.springsource.bundlor.support.DefaultManifestGeneratorContributorsFactory;
import com.springsource.bundlor.support.ManifestGeneratorContributors;
import com.springsource.bundlor.support.StandardManifestGenerator;
import com.springsource.bundlor.support.classpath.ClassPathFactory;
import com.springsource.bundlor.support.manifestwriter.ManifestWriterFactory;
import com.springsource.bundlor.support.properties.PropertiesSource;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandLineBundlorExecutor
implements BundlorExecutor {
    private final ClassPath inputClassPath;
    private final ManifestWriter manifestWriter;
    private final ManifestContents manifestTemplate;
    private final ManifestGenerator manifestGenerator;
    private final ManifestValidator manifestValidator;

    public CommandLineBundlorExecutor(Configuration configuration, ConfigurationValidator configurationValidator, ClassPathFactory classPathFactory, ManifestWriterFactory manifestWriterFactory, ManifestTemplateFactory manifestTemplateFactory, PropertiesSourceFactory propertiesSourceFactory, OsgiProfileFactory osgiProfileFactory) {
        configurationValidator.validate(configuration);
        this.inputClassPath = classPathFactory.create(configuration.getInputPath());
        this.manifestWriter = manifestWriterFactory.create(configuration.getInputPath(), configuration.getOutputPath());
        this.manifestTemplate = manifestTemplateFactory.create(configuration.getManifestTemplatePath());
        List<PropertiesSource> properties = propertiesSourceFactory.create(configuration.getPropertiesPath(), configuration.getProperties());
        properties.add(osgiProfileFactory.create(configuration.getOsgiProfilePath()));
        this.manifestGenerator = new StandardManifestGenerator(this.createContributors(properties));
        this.manifestValidator = new StandardManifestValidator(DefaultManifestValidatorContributorsFactory.create());
    }

    @Override
    public List<String> execute() {
        ManifestContents manifest = this.manifestGenerator.generate(this.manifestTemplate, new ClassPath[]{this.inputClassPath});
        try {
            this.manifestWriter.write(manifest);
        }
        finally {
            this.manifestWriter.close();
        }
        return this.manifestValidator.validate(manifest);
    }

    private ManifestGeneratorContributors createContributors(List<PropertiesSource> properties) {
        return DefaultManifestGeneratorContributorsFactory.create((PropertiesSource[])properties.toArray(new PropertiesSource[properties.size()]));
    }
}

