/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.commandline;

import com.springsource.bundlor.commandline.BundlorExecutor;
import com.springsource.bundlor.commandline.internal.CommandLineBundlorExecutor;
import com.springsource.bundlor.commandline.internal.Configuration;
import com.springsource.bundlor.commandline.internal.OptionsFactory;
import com.springsource.bundlor.commandline.internal.support.StandardConfigurationValidator;
import com.springsource.bundlor.commandline.internal.support.StandardManifestTemplateFactory;
import com.springsource.bundlor.commandline.internal.support.StandardOsgiProfileFactory;
import com.springsource.bundlor.commandline.internal.support.StandardPropertiesSourceFactory;
import com.springsource.bundlor.support.classpath.ClassPathFactory;
import com.springsource.bundlor.support.classpath.StandardClassPathFactory;
import com.springsource.bundlor.support.manifestwriter.ManifestWriterFactory;
import com.springsource.bundlor.support.manifestwriter.StandardManifestWriterFactory;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Bundlor {
    private static final Options OPTIONS = new OptionsFactory().create();

    public static final void main(String[] args) {
        new Bundlor().run(args);
    }

    final void run(String[] args) {
        CommandLine commandLine = null;
        Configuration configuration = null;
        try {
            commandLine = new PosixParser().parse(OPTIONS, args);
            configuration = new Configuration(commandLine);
        }
        catch (ParseException parseException) {
            new HelpFormatter().printHelp("bundlor.[sh | bat] [OPTION]...", OPTIONS);
            this.exit(-1);
        }
        List<String> warnings = this.getBundlorExecutor(configuration).execute();
        if (warnings.size() > 0) {
            System.out.println("Bundlor Warnings:");
            for (String warning : warnings) {
                System.out.println("    " + warning);
            }
            if (commandLine.hasOption("f")) {
                String message = String.format("Bundlor returned warnings.  Please fix manifest template at '%s' and try again.", configuration.getManifestTemplatePath());
                System.err.println(message);
                this.exit(-1);
            }
        }
    }

    protected BundlorExecutor getBundlorExecutor(Configuration configuration) {
        return new CommandLineBundlorExecutor(configuration, new StandardConfigurationValidator(), (ClassPathFactory)new StandardClassPathFactory(), (ManifestWriterFactory)new StandardManifestWriterFactory(), new StandardManifestTemplateFactory(), new StandardPropertiesSourceFactory(), new StandardOsgiProfileFactory());
    }

    protected void exit(int code) {
        System.exit(code);
    }
}

