/*
 * Copyright 2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.commandline.internal.support;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import org.springframework.util.StringUtils;

import com.springsource.bundlor.commandline.internal.PropertiesSourceFactory;
import com.springsource.bundlor.support.properties.FileSystemPropertiesSource;
import com.springsource.bundlor.support.properties.PropertiesPropertiesSource;
import com.springsource.bundlor.support.properties.PropertiesSource;
import com.springsource.bundlor.support.properties.SystemPropertiesSource;

public class StandardPropertiesSourceFactory implements PropertiesSourceFactory {

    public List<PropertiesSource> create(String propertiesPath, Properties properties) {
        List<PropertiesSource> propertySources = new ArrayList<PropertiesSource>();

        propertySources.add(new SystemPropertiesSource());

        if (StringUtils.hasText(propertiesPath)) {
            propertySources.add(new FileSystemPropertiesSource(new File(propertiesPath)));
        }

        propertySources.add(new PropertiesPropertiesSource(properties));

        return propertySources;
    }

}
