/*
 * Copyright 2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.commandline.internal.support;

import java.io.File;

import org.springframework.util.StringUtils;

import com.springsource.bundlor.commandline.internal.OsgiProfileFactory;
import com.springsource.bundlor.support.properties.EmptyPropertiesSource;
import com.springsource.bundlor.support.properties.FileSystemPropertiesSource;
import com.springsource.bundlor.support.properties.PropertiesSource;

public class StandardOsgiProfileFactory implements OsgiProfileFactory {

    public PropertiesSource create(String osgiProfilePath) {
        if (StringUtils.hasText(osgiProfilePath)) {
            return new FileSystemPropertiesSource(new File(osgiProfilePath));
        }

        return new EmptyPropertiesSource();
    }

}
