/*
 * Copyright 2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.commandline.internal;

import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class OptionsFactory {

    @SuppressWarnings("static-access")
    public Options create() {
        Options options = new Options();

        options.addOption(OptionBuilder //
        .withArgName("path") //
        .withDescription("The path to the input source") //
        .hasArg() //
        .isRequired() //
        .create("i"));

        options.addOption(OptionBuilder //
        .withArgName("path") //
        .withDescription("The path to the output location. If unspecified then, System.out.") //
        .hasArg() //
        .create("o"));

        options.addOption(OptionBuilder //
        .withArgName("path") //
        .withDescription("The path to the manifest template file") //
        .hasArg() //
        .create("m"));

        options.addOption(OptionBuilder //
        .withArgName("path") //
        .withDescription("The path to an OSGi profile in properties file form") //
        .hasArg() //
        .create("p"));

        options.addOption(OptionBuilder //
        .withArgName("path") //
        .withDescription("The path to a file of properties for substitution in properties file form") //
        .hasArg() //
        .create("r"));

        options.addOption("f", null, false, "Fail with a non-zero exit code if warnings are returned");

        options.addOption(OptionBuilder //
        .withArgName("property=value") //
        .hasArgs(2) //
        .withValueSeparator() //
        .withDescription("A property to use for substitution") //
        .create("D"));

        return options;
    }
}
