/*
 * Copyright 2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.commandline.internal;

import java.util.Properties;

import org.apache.commons.cli.CommandLine;

public final class Configuration {

    private final String inputPath;

    private final String outputPath;

    private final String manifestTemplatePath;

    private final String osgiProfilePath;

    private final String propertiesPath;

    private final Properties properties;

    Configuration() {
        this.inputPath = "";
        this.outputPath = "";
        this.manifestTemplatePath = "";
        this.osgiProfilePath = "";
        this.propertiesPath = "";
        this.properties = new Properties();
    }

    public Configuration(CommandLine commandLine) {
        this.inputPath = commandLine.getOptionValue("i");
        this.outputPath = commandLine.getOptionValue("o");
        this.manifestTemplatePath = commandLine.getOptionValue("m");
        this.osgiProfilePath = commandLine.getOptionValue("p");
        this.propertiesPath = commandLine.getOptionValue("r");
        this.properties = commandLine.getOptionProperties("D");
    }

    public String getInputPath() {
        return inputPath;
    }

    public String getOutputPath() {
        return outputPath;
    }

    public String getManifestTemplatePath() {
        return manifestTemplatePath;
    }

    public String getOsgiProfilePath() {
        return osgiProfilePath;
    }

    public String getPropertiesPath() {
        return propertiesPath;
    }

    public Properties getProperties() {
        return properties;
    }
}
