/*
 * Copyright 2008-2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.blint.support.contributors;

import java.util.HashSet;
import java.util.Set;

import com.springsource.bundlor.blint.support.Validator;
import com.springsource.bundlor.util.BundleManifestUtils;
import com.springsource.util.osgi.manifest.BundleManifest;
import com.springsource.util.osgi.manifest.ExportedPackage;
import com.springsource.util.osgi.manifest.ImportedPackage;
import com.springsource.util.parser.manifest.ManifestContents;

/**
 * Validates that packages that are exported are not also imported
 * <p />
 * 
 * <strong>Concurrent Semantics</strong><br />
 * 
 * Threadsafe
 * 
 * @author Ben Hale
 */
public final class ExportedNotImportedValidator implements Validator {

    private static final String MESSAGE = "The manifest both imports and exports the package %s";

    /**
     * {@inheritDoc}
     */
    public Set<String> validate(ManifestContents manifest) {
        BundleManifest bundleManifest = BundleManifestUtils.createBundleManifest(manifest);
        Set<String> warnings = new HashSet<String>();

        for (ExportedPackage exportedPackage : bundleManifest.getExportPackage().getExportedPackages()) {
            String exportedName = exportedPackage.getPackageName();
            for (ImportedPackage importedPackage : bundleManifest.getImportPackage().getImportedPackages()) {
                if (importedPackage.getPackageName().equals(exportedName)) {
                    warnings.add(String.format(MESSAGE, exportedName));
                }
            }
        }

        return warnings;
    }

}
