/*
 * Copyright 2008-2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.blint.support;

import java.util.Set;

import com.springsource.util.parser.manifest.ManifestContents;

/**
 * Implementations of this interface have the opportunity to check a bundle's manifest and create warnings against it.
 * <p />
 * 
 * <strong>Concurrent Semantics</strong><br />
 * 
 * Implementations should be threadsafe
 * 
 * @author Ben Hale
 */
public interface Validator {

    /**
     * Check for warnings against a bundle's manifest
     * 
     * @param manifest the manifest to validate
     * @return a collection of warnings
     */
    Set<String> validate(ManifestContents manifest);

}
