/*
 * Copyright 2008-2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.blint.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.springsource.bundlor.blint.ManifestValidator;
import com.springsource.util.parser.manifest.ManifestContents;

/**
 * Standard Implementation of {@link ManifestValidator}.
 * <p />
 * 
 * <strong>Concurrent Semantics</strong><br />
 * 
 * Threadsafe
 * 
 * @author Ben Hale
 */
public final class StandardManifestValidator implements ManifestValidator {

    private final ManifestValidatorContributors contributors;

    public StandardManifestValidator(ManifestValidatorContributors contributors) {
        this.contributors = contributors;
    }

    /**
     * {@inheritDoc}
     */
    public List<String> validate(ManifestContents manifest) {
        Set<String> warnings = new HashSet<String>();
        for (Validator validator : this.contributors.getValidators()) {
            try {
                warnings.addAll(validator.validate(manifest));
            } catch (Exception e) {
                // Swallow to allow others to proceed
            }
        }

        List<String> warningsList = new ArrayList<String>(warnings);
        Collections.sort(warningsList);
        return Collections.unmodifiableList(warningsList);
    }

}
