/*
 * Copyright 2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.blint.support;

import com.springsource.bundlor.blint.support.contributors.BundleManifestVersionValidator;
import com.springsource.bundlor.blint.support.contributors.BundleSymbolicNameValidator;
import com.springsource.bundlor.blint.support.contributors.ExportedNotImportedValidator;
import com.springsource.bundlor.blint.support.contributors.SignedJarFileValidator;
import com.springsource.bundlor.blint.support.contributors.VersionedExportsValidator;
import com.springsource.bundlor.blint.support.contributors.VersionedImportsRangeValidator;
import com.springsource.bundlor.blint.support.contributors.VersionedImportsValidator;

public final class DefaultManifestValidatorContributorsFactory {

    public static ManifestValidatorContributors create() {
        ManifestValidatorContributors contributors = new ManifestValidatorContributors();

        contributors //
        .addValidator(new BundleManifestVersionValidator()) //
        .addValidator(new BundleSymbolicNameValidator()) //
        .addValidator(new VersionedImportsValidator()) //
        .addValidator(new VersionedExportsValidator()) //
        .addValidator(new ExportedNotImportedValidator()) //
        .addValidator(new SignedJarFileValidator()) //
        .addValidator(new VersionedImportsRangeValidator());

        return contributors;
    }
}
