/*
 * Copyright 2008-2009 SpringSource
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.springsource.bundlor.blint;

import java.util.List;

import com.springsource.util.parser.manifest.ManifestContents;

/**
 * Main entry point for manifest validation. Clients provide an already transformed manifest or bundle and are returned
 * a list of warnings against the contained contained within.
 * <p />
 * 
 * <strong>Concurrent Semantics</strong><br />
 * 
 * Implementations must be threadsafe.
 * 
 * @author Ben Hale
 */
public interface ManifestValidator {

    /**
     * Check for warnings in a manifest directly
     * 
     * @param manifest The manifest to check
     * @return a list of warnings for this manifest
     */
    List<String> validate(ManifestContents manifest);

}
