/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.exceptions;

import com.spotify.docker.client.exceptions.DockerException;
import java.net.URI;

public class DockerRequestException
extends DockerException {
    private final String method;
    private final URI uri;
    private final int status;
    private final String message;

    public DockerRequestException(String method, URI uri, Throwable cause) {
        this(method, uri, 0, null, cause);
    }

    public DockerRequestException(String method, URI uri, int status, Throwable cause) {
        this(method, uri, status, null, cause);
    }

    public DockerRequestException(String method, URI uri) {
        this(method, uri, 0, null, null);
    }

    public DockerRequestException(String method, URI uri, int status) {
        this(method, uri, status, null, null);
    }

    public DockerRequestException(String method, URI uri, int status, String message) {
        this(method, uri, status, message, null);
    }

    public DockerRequestException(String method, URI uri, int status, String message, Throwable cause) {
        super("Request error: " + method + " " + uri + ": " + status, cause);
        this.method = method;
        this.uri = uri;
        this.status = status;
        this.message = message;
    }

    public String method() {
        return this.method;
    }

    public URI uri() {
        return this.uri;
    }

    public int status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }
}

