/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.ForeignMultiKeyNullifier;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.KeyLocation;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.RefreshException;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import java.util.Collection;
import java.util.Set;

public class PersistKeyCreator
implements SecondaryKeyCreator,
SecondaryMultiKeyCreator,
ForeignMultiKeyNullifier {
    private volatile Catalog catalog;
    private volatile Format priKeyFormat;
    private final String keyName;
    private volatile Format keyFormat;
    private final boolean toMany;

    static boolean isManyType(Class cls) {
        return cls.isArray() || Collection.class.isAssignableFrom(cls);
    }

    public PersistKeyCreator(Catalog catalogParam, EntityMetadata entityMeta, String keyClassName, SecondaryKeyMetadata secKeyMeta, boolean rawAccess) {
        this.catalog = catalogParam;
        try {
            this.getFormats(entityMeta, keyClassName, secKeyMeta, rawAccess);
        }
        catch (RefreshException e) {
            this.catalog = e.refresh();
            try {
                this.getFormats(entityMeta, keyClassName, secKeyMeta, rawAccess);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
        this.keyName = secKeyMeta.getKeyName();
        Relationship rel = secKeyMeta.getRelationship();
        this.toMany = rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY;
    }

    private void getFormats(EntityMetadata entityMeta, String keyClassName, SecondaryKeyMetadata secKeyMeta, boolean rawAccess) throws RefreshException {
        this.priKeyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, entityMeta.getPrimaryKey().getClassName(), rawAccess);
        this.keyFormat = PersistEntityBinding.getOrCreateFormat(this.catalog, keyClassName, rawAccess);
        if (this.keyFormat == null) {
            throw new IllegalArgumentException("Not a key class: " + keyClassName);
        }
        if (this.keyFormat.isPrimitive()) {
            throw new IllegalArgumentException("Use a primitive wrapper class instead of class: " + this.keyFormat.getClassName());
        }
    }

    public boolean createSecondaryKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry result) {
        try {
            return this.createSecondaryKeyInternal(secondary, key, data, result);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                return this.createSecondaryKeyInternal(secondary, key, data, result);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private boolean createSecondaryKeyInternal(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry result) throws RefreshException {
        if (this.toMany) {
            throw DbCompat.unexpectedState();
        }
        KeyLocation loc = this.moveToKey(key, data);
        if (loc != null) {
            RecordOutput output = new RecordOutput(this.catalog, true);
            loc.format.copySecKey(loc.input, output);
            TupleBase.outputToEntry(output, result);
            return true;
        }
        return false;
    }

    public void createSecondaryKeys(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, Set results) {
        try {
            this.createSecondaryKeysInternal(secondary, key, data, results);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                this.createSecondaryKeysInternal(secondary, key, data, results);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private void createSecondaryKeysInternal(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, Set results) throws RefreshException {
        if (!this.toMany) {
            throw DbCompat.unexpectedState();
        }
        KeyLocation loc = this.moveToKey(key, data);
        if (loc != null) {
            loc.format.copySecMultiKey(loc.input, this.keyFormat, results);
        }
    }

    public boolean nullifyForeignKey(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry secKey) {
        try {
            return this.nullifyForeignKeyInternal(secondary, key, data, secKey);
        }
        catch (RefreshException e) {
            e.refresh();
            try {
                return this.nullifyForeignKeyInternal(secondary, key, data, secKey);
            }
            catch (RefreshException e2) {
                throw DbCompat.unexpectedException(e2);
            }
        }
    }

    private boolean nullifyForeignKeyInternal(SecondaryDatabase secondary, DatabaseEntry key, DatabaseEntry data, DatabaseEntry secKey) throws RefreshException {
        RawObject entity = (RawObject)PersistEntityBinding.readEntity(this.catalog, key, null, data, true);
        Format entityFormat = (Format)entity.getType();
        Object secKeyObject = null;
        if (this.toMany) {
            secKeyObject = PersistKeyBinding.readKey(this.keyFormat, this.catalog, secKey.getData(), secKey.getOffset(), secKey.getSize(), true);
        }
        if (entityFormat.nullifySecKey(this.catalog, entity, this.keyName, secKeyObject)) {
            PersistEntityBinding.writeEntity(entityFormat, this.catalog, entity, data, true);
            return true;
        }
        return false;
    }

    private KeyLocation moveToKey(DatabaseEntry priKey, DatabaseEntry data) throws RefreshException {
        RecordInput input = new RecordInput(this.catalog, true, priKey, this.priKeyFormat.getId(), data.getData(), data.getOffset(), data.getSize());
        int formatId = input.readPackedInt();
        Format entityFormat = this.catalog.getFormat(formatId, true);
        input.registerEntityFormat(entityFormat);
        Format fieldFormat = entityFormat.skipToSecKey(input, this.keyName);
        if (fieldFormat != null) {
            return input.getKeyLocation(fieldFormat);
        }
        return null;
    }

    void refresh(PersistCatalog newCatalog) {
        this.catalog = newCatalog;
        this.keyFormat = this.catalog.getFormat(this.keyFormat.getClassName());
        this.priKeyFormat = this.catalog.getFormat(this.priKeyFormat.getClassName());
    }
}

