/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.latch.LatchStatDefinition;
import com.sleepycat.je.txn.LockStatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import java.io.Serializable;

public class LockStats
implements Serializable {
    private static final long serialVersionUID = 172109534L;
    private final StatGroup basicStats;
    private final StatGroup latchStats;
    private final StatGroup tableStats;

    public LockStats(StatGroup basicStats, StatGroup latchStats, StatGroup tableStats) {
        this.basicStats = basicStats;
        this.latchStats = latchStats;
        this.tableStats = tableStats;
    }

    public int getNOwners() {
        return this.tableStats.getInt(LockStatDefinition.LOCK_OWNERS);
    }

    public int getNReadLocks() {
        return this.tableStats.getInt(LockStatDefinition.LOCK_READ_LOCKS);
    }

    public int getNTotalLocks() {
        return this.tableStats.getInt(LockStatDefinition.LOCK_TOTAL);
    }

    public int getNWaiters() {
        return this.tableStats.getInt(LockStatDefinition.LOCK_WAITERS);
    }

    public int getNWriteLocks() {
        return this.tableStats.getInt(LockStatDefinition.LOCK_WRITE_LOCKS);
    }

    public long getNRequests() {
        return this.basicStats.getLong(LockStatDefinition.LOCK_REQUESTS);
    }

    public long getNWaits() {
        return this.basicStats.getLong(LockStatDefinition.LOCK_WAITS);
    }

    public int getNAcquiresNoWaiters() {
        return this.tableStats.getInt(LatchStatDefinition.LATCH_NO_WAITERS);
    }

    public int getNAcquiresSelfOwned() {
        return this.tableStats.getInt(LatchStatDefinition.LATCH_SELF_OWNED);
    }

    public int getNAcquiresWithContention() {
        return this.tableStats.getInt(LatchStatDefinition.LATCH_CONTENTION);
    }

    public int getNAcquiresNoWaitSuccessful() {
        return this.tableStats.getInt(LatchStatDefinition.LATCH_NOWAIT_SUCCESS);
    }

    public int getNAcquiresNoWaitUnSuccessful() {
        return this.tableStats.getInt(LatchStatDefinition.LATCH_NOWAIT_UNSUCCESS);
    }

    public int getNReleases() {
        return this.tableStats.getInt(LatchStatDefinition.LATCH_RELEASES);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.basicStats);
        sb.append(this.latchStats);
        sb.append(this.tableStats);
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.basicStats.toStringVerbose());
        sb.append(this.latchStats.toStringVerbose());
        sb.append(this.tableStats.toStringVerbose());
        return sb.toString();
    }
}

