/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class BasicBSONCallback
implements BSONCallback {
    private Object _root;
    private final LinkedList<BSONObject> _stack = new LinkedList();
    private final LinkedList<String> _nameStack = new LinkedList();

    public BasicBSONCallback() {
        this.reset();
    }

    public BSONObject create() {
        return new BasicBSONObject();
    }

    protected BSONObject createList() {
        return new BasicBSONList();
    }

    @Override
    public BSONCallback createBSONCallback() {
        return new BasicBSONCallback();
    }

    public BSONObject create(boolean array, List<String> path) {
        if (array) {
            return this.createList();
        }
        return this.create();
    }

    @Override
    public void objectStart() {
        if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        this.objectStart(false);
    }

    @Override
    public void objectStart(boolean array) {
        this._root = this.create(array, null);
        this._stack.add((BSONObject)this._root);
    }

    @Override
    public void objectStart(String name) {
        this.objectStart(false, name);
    }

    public void objectStart(boolean array, String name) {
        this._nameStack.addLast(name);
        BSONObject o = this.create(array, this._nameStack);
        this._stack.getLast().put(name, o);
        this._stack.addLast(o);
    }

    @Override
    public Object objectDone() {
        BSONObject o = this._stack.removeLast();
        if (this._nameStack.size() > 0) {
            this._nameStack.removeLast();
        } else if (this._stack.size() > 0) {
            throw new IllegalStateException("something is wrong");
        }
        return !BSON.hasDecodeHooks() ? o : (BSONObject)BSON.applyDecodingHooks(o);
    }

    @Override
    public void arrayStart() {
        this.objectStart(true);
    }

    @Override
    public void arrayStart(String name) {
        this.objectStart(true, name);
    }

    @Override
    public Object arrayDone() {
        return this.objectDone();
    }

    @Override
    public void gotNull(String name) {
        this.cur().put(name, null);
    }

    @Override
    public void gotUndefined(String name) {
    }

    @Override
    public void gotMinKey(String name) {
        this.cur().put(name, new MinKey());
    }

    @Override
    public void gotMaxKey(String name) {
        this.cur().put(name, new MaxKey());
    }

    @Override
    public void gotBoolean(String name, boolean v) {
        this._put(name, v);
    }

    @Override
    public void gotDouble(String name, double v) {
        this._put(name, v);
    }

    @Override
    public void gotInt(String name, int v) {
        this._put(name, v);
    }

    @Override
    public void gotLong(String name, long v) {
        this._put(name, v);
    }

    @Override
    public void gotDate(String name, long millis) {
        this._put(name, new Date(millis));
    }

    @Override
    public void gotRegex(String name, String pattern, String flags) {
        this._put(name, Pattern.compile(pattern, BSON.regexFlags(flags)));
    }

    @Override
    public void gotString(String name, String v) {
        this._put(name, v);
    }

    @Override
    public void gotSymbol(String name, String v) {
        this._put(name, v);
    }

    @Override
    public void gotTimestamp(String name, int time, int inc) {
        this._put(name, new BSONTimestamp(time, inc));
    }

    @Override
    public void gotObjectId(String name, ObjectId id) {
        this._put(name, id);
    }

    @Override
    public void gotDBRef(String name, String ns, ObjectId id) {
        this._put(name, new BasicBSONObject("$ns", ns).append("$id", id));
    }

    @Override
    @Deprecated
    public void gotBinaryArray(String name, byte[] data) {
        this.gotBinary(name, (byte)0, data);
    }

    @Override
    public void gotBinary(String name, byte type, byte[] data) {
        this._put(name, new Binary(type, data));
    }

    @Override
    public void gotUUID(String name, long part1, long part2) {
        this._put(name, new UUID(part1, part2));
    }

    @Override
    public void gotCode(String name, String code) {
        this._put(name, new Code(code));
    }

    @Override
    public void gotCodeWScope(String name, String code, Object scope) {
        this._put(name, new CodeWScope(code, (BSONObject)scope));
    }

    protected void _put(String name, Object o) {
        this.cur().put(name, !BSON.hasDecodeHooks() ? o : BSON.applyDecodingHooks(o));
    }

    protected BSONObject cur() {
        return this._stack.getLast();
    }

    protected String curName() {
        return !this._nameStack.isEmpty() ? this._nameStack.getLast() : null;
    }

    @Override
    public Object get() {
        return this._root;
    }

    protected void setRoot(Object o) {
        this._root = o;
    }

    protected boolean isStackEmpty() {
        return this._stack.size() < 1;
    }

    @Override
    public void reset() {
        this._root = null;
        this._stack.clear();
        this._nameStack.clear();
    }
}

