/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.exception;

import com.sequoiadb.exception.SDBError;
import com.sequoiadb.exception.SDBErrorLookup;

public class BaseException
extends RuntimeException {
    private static final long serialVersionUID = -6115487863398926195L;
    private SDBError error = new SDBError();
    private String infos = "";

    public BaseException(String errorType, Object ... info) {
        this.error.setErrorType(errorType);
        if (info != null) {
            for (Object obj : info) {
                this.infos = this.infos + obj + " ";
            }
        } else {
            this.infos = "no more exception info";
        }
        try {
            this.error.setErrorCode(SDBErrorLookup.getErrorCodeByType(errorType));
            this.error.setErrorDescription("errorType:" + errorType + "," + SDBErrorLookup.getErrorDescriptionByType(errorType) + "\n Exception Detail:" + this.infos);
        }
        catch (Exception e) {
            this.error.setErrorCode(0);
            this.error.setErrorDescription("Unknown Error\n Exception Detail:" + this.infos);
        }
    }

    public BaseException(int errorCode, Object ... info) {
        this.error.setErrorCode(errorCode);
        if (info != null) {
            for (Object obj : info) {
                this.infos = this.infos + obj + " ";
            }
        } else {
            this.infos = "no more exception info";
        }
        try {
            this.error.setErrorType(SDBErrorLookup.getErrorTypeByCode(errorCode));
            this.error.setErrorDescription("errorCode:" + errorCode + "," + SDBErrorLookup.getErrorDescriptionByCode(errorCode) + "\n Exception Detail:" + this.infos);
        }
        catch (Exception e) {
            this.error.setErrorType("UNKNOWN");
            this.error.setErrorDescription("Unknown Error\n Exception Detail:" + this.infos);
        }
    }

    @Override
    public String getMessage() {
        return this.error.getErrorDescription();
    }

    public String getErrorType() {
        return this.error.getErrorType();
    }

    public int getErrorCode() {
        return this.error.getErrorCode();
    }
}

