/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCollection;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.util.SDBMessageHelper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;

public class DBCursor {
    private long reqId;
    private SDBMessage sdbMessage;
    private DBCollection dbc;
    private IConnection connection;
    private BSONObject current = null;
    private List<BSONObject> list;
    private byte[] currentRaw;
    private List<byte[]> listRaw;
    private int index;
    private boolean hasMore;
    private byte times;
    private long contextId;
    boolean endianConvert;
    private Sequoiadb sequoiadb;

    DBCursor() {
        this.hasMore = false;
        this.sdbMessage = null;
        this.connection = null;
        this.dbc = null;
        this.list = null;
        this.listRaw = null;
        this.index = -1;
        this.reqId = 0L;
        this.contextId = -1L;
        this.endianConvert = false;
        this.sequoiadb = null;
    }

    DBCursor(SDBMessage rtnSDBMessage, DBCollection dbc) {
        this.dbc = dbc;
        this.sequoiadb = dbc.getSequoiadb();
        this.endianConvert = this.sequoiadb.endianConvert;
        this.connection = dbc.getConnection();
        this.sdbMessage = rtnSDBMessage;
        this.sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        this.sdbMessage.setNumReturned(-1);
        this.list = new ArrayList<BSONObject>();
        this.listRaw = new ArrayList<byte[]>();
        this.reqId = rtnSDBMessage.getRequestID();
        this.contextId = rtnSDBMessage.getContextIDList().get(0);
        this.hasMore = false;
        this.current = null;
        this.times = 0;
        this.index = -1;
        List<BSONObject> tmpList = this.sdbMessage.getObjectList();
        if (null != tmpList && tmpList.size() != 0) {
            this.list = tmpList;
        }
    }

    DBCursor(SDBMessage rtnSDBMessage, Sequoiadb sdb) {
        this.connection = sdb.getConnection();
        this.sequoiadb = sdb;
        this.sdbMessage = rtnSDBMessage;
        this.sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        this.sdbMessage.setNumReturned(-1);
        this.list = new ArrayList<BSONObject>();
        this.listRaw = new ArrayList<byte[]>();
        this.reqId = rtnSDBMessage.getRequestID();
        this.contextId = rtnSDBMessage.getContextIDList().get(0);
        this.hasMore = false;
        this.current = null;
        this.times = 0;
        this.index = -1;
        this.endianConvert = sdb.endianConvert;
        List<BSONObject> tmpList = this.sdbMessage.getObjectList();
        if (null != tmpList && tmpList.size() != 0) {
            this.list = tmpList;
        }
    }

    public boolean hasNext() throws BaseException {
        if (this.connection == null) {
            return this.hasMore;
        }
        if (this.times > 0 || this.sdbMessage == null) {
            return this.hasMore;
        }
        if (this.list == null || this.index >= this.list.size() - 1) {
            this.getListFromDB(true);
            this.index = -1;
        }
        this.hasMore = this.list != null && this.list.size() != 0;
        this.times = (byte)(this.times + 1);
        return this.hasMore;
    }

    public boolean hasNextRaw() throws BaseException {
        if (this.connection == null) {
            return this.hasMore;
        }
        if (this.times > 0 || this.sdbMessage == null) {
            return this.hasMore;
        }
        if (this.listRaw == null || this.index >= this.listRaw.size() - 1) {
            this.getListFromDB(false);
            this.index = -1;
        }
        this.hasMore = this.listRaw != null && this.listRaw.size() != 0;
        this.times = (byte)(this.times + 1);
        return this.hasMore;
    }

    public BSONObject getNext() throws BaseException {
        if (this.connection == null) {
            throw new BaseException("SDB_RTN_CONTEXT_NOTEXIST", this.connection);
        }
        if (this.times == 0) {
            this.hasNext();
        }
        if (this.hasMore) {
            ++this.index;
            this.current = this.list.get(this.index);
            this.times = 0;
            return this.current;
        }
        return null;
    }

    public byte[] getNextRaw() throws BaseException {
        if (this.connection == null) {
            throw new BaseException("SDB_RTN_CONTEXT_NOTEXIST", this.connection);
        }
        if (this.times == 0) {
            this.hasNextRaw();
        }
        if (this.hasMore) {
            ++this.index;
            this.currentRaw = this.listRaw.get(this.index);
            this.times = 0;
            return this.currentRaw;
        }
        return null;
    }

    public BSONObject getCurrent() throws BaseException {
        if (this.connection == null) {
            throw new BaseException("SDB_RTN_CONTEXT_NOTEXIST", new Object[0]);
        }
        if (this.index == -1) {
            return this.getNext();
        }
        return this.list.get(this.index);
    }

    public void close() throws BaseException {
        this.killCursor();
        this.sdbMessage = null;
        this.dbc = null;
        this.hasMore = false;
        this.current = null;
        this.list = null;
        this.listRaw = null;
    }

    private void getListFromDB(boolean decode) {
        if (this.connection == null) {
            throw new BaseException("SDB_NOT_CONNECTED", new Object[0]);
        }
        if (this.contextId == -1L) {
            this.hasMore = false;
            this.index = -1;
            this.current = null;
            this.list = null;
            this.listRaw = null;
            return;
        }
        if (decode) {
            this.list.clear();
        } else {
            this.listRaw.clear();
        }
        this.sdbMessage.setRequestID(this.reqId);
        this.sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_GETMORE);
        byte[] request = SDBMessageHelper.buildGetMoreRequest(this.sdbMessage, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtnSDBMessage = null;
        rtnSDBMessage = decode ? SDBMessageHelper.msgExtractReply(byteBuffer) : SDBMessageHelper.msgExtractReplyRaw(byteBuffer);
        if (rtnSDBMessage.getOperationCode() != SequoiadbConstants.Operation.OP_GETMORE_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtnSDBMessage.getOperationCode()});
        }
        int flags = rtnSDBMessage.getFlags();
        if (flags == SequoiadbConstants.SDB_DMS_EOC || this.contextId != rtnSDBMessage.getContextIDList().get(0)) {
            this.hasMore = false;
            this.index = -1;
            this.current = null;
            this.list = null;
            this.listRaw = null;
        } else {
            if (flags != 0) {
                throw new BaseException(flags, new Object[0]);
            }
            this.reqId = rtnSDBMessage.getRequestID();
            if (decode) {
                this.list = rtnSDBMessage.getObjectList();
            } else {
                this.listRaw = rtnSDBMessage.getObjectListRaw();
            }
        }
    }

    private void killCursor() {
        if (this.connection == null && this.contextId == -1L) {
            return;
        }
        long[] contextIds = new long[]{this.contextId};
        byte[] request = SDBMessageHelper.buildKillCursorMsg(this.sequoiadb.getNextRequstID(), contextIds, this.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        assert (rtnSDBMessage.getOperationCode() == SequoiadbConstants.Operation.OP_KILL_CONTEXT_RES);
        assert (rtnSDBMessage.getFlags() == 0);
        this.connection = null;
        this.contextId = -1L;
    }
}

