/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.sensorsdata.analytics.javasdk.bean.FailedData;
import com.sensorsdata.analytics.javasdk.common.Pair;
import com.sensorsdata.analytics.javasdk.common.SensorsDataTypeEnum;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorsAnalyticsUtil {
    private static final Logger log = LoggerFactory.getLogger(SensorsAnalyticsUtil.class);
    public static final Pattern KEY_PATTERN = Pattern.compile("^((?!^distinct_id$|^original_id$|^event_id$|^time$|^properties$|^id$|^first_id$|^second_id$|^users$|^events$|^event$|^user_id$|^date$|^datetime$|^user_group|^user_tag)[a-zA-Z_$][a-zA-Z\\d_$]{0,99})$", 2);

    public static String strJoin(String[] arr, String sep) {
        StringBuilder sbStr = new StringBuilder();
        int il = arr.length;
        for (int i = 0; i < il; ++i) {
            if (i > 0) {
                sbStr.append(sep);
            }
            sbStr.append(arr[i]);
        }
        return sbStr.toString();
    }

    public static ObjectMapper getJsonObjectMapper() {
        ObjectMapper jsonObjectMapper = new ObjectMapper();
        jsonObjectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        jsonObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        jsonObjectMapper.setTimeZone(TimeZone.getDefault());
        jsonObjectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
        return jsonObjectMapper;
    }

    public static void assertIdentityMap(String actionType, Map<String, String> identityMap) throws InvalidArgumentException {
        for (Map.Entry<String, String> entry : identityMap.entrySet()) {
            SensorsAnalyticsUtil.assertKey(actionType, entry.getKey());
            SensorsAnalyticsUtil.assertValue(actionType, entry.getValue());
        }
    }

    public static void assertProperties(String eventType, Map<String, Object> properties) throws InvalidArgumentException {
        if (null == properties) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean isFilterKey;
            String value;
            if (property.getKey().equals("$is_login_id")) {
                if (property.getValue() instanceof Boolean) continue;
                throw new InvalidArgumentException("The property value of '$is_login_id' should be Boolean.");
            }
            SensorsAnalyticsUtil.assertKey("property", property.getKey());
            if (!(property.getValue() instanceof Number || property.getValue() instanceof Date || property.getValue() instanceof String || property.getValue() instanceof Boolean || property.getValue() instanceof List)) {
                String type = property.getValue() == null ? "null" : property.getValue().getClass().toString();
                throw new InvalidArgumentException(String.format("The property '%s' should be a basic type: Number, String, Date, Boolean, List<String>.The current type is %s.", property.getKey(), type));
            }
            if (property.getKey().equals("$time") && !(property.getValue() instanceof Date)) {
                throw new InvalidArgumentException("The property '$time' should be a java.util.Date.");
            }
            if (property.getValue() instanceof List && !eventType.equals("profile_increment")) {
                ListIterator<String> it = ((List)property.getValue()).listIterator();
                while (it.hasNext()) {
                    Object element = it.next();
                    if (!(element instanceof String)) {
                        throw new InvalidArgumentException(String.format("The property '%s' should be a list of String.", property.getKey()));
                    }
                    if (((String)element).length() <= 8192) continue;
                    it.set(((String)element).substring(0, 8192));
                }
            }
            if (property.getValue() instanceof String && (value = (String)property.getValue()).length() > 8192) {
                property.setValue(value.substring(0, 8192));
            }
            boolean bl = isFilterKey = property.getKey().equals("$project") || property.getKey().equals("$token");
            if (eventType.equals("profile_increment")) {
                if (isFilterKey || property.getValue() instanceof Number) continue;
                String type = property.getValue() == null ? "null" : property.getValue().getClass().toString();
                throw new InvalidArgumentException(String.format("The property value of PROFILE_INCREMENT should be a Number.The current type is %s.", type));
            }
            if (!eventType.equals("profile_append") || isFilterKey || property.getValue() instanceof List) continue;
            throw new InvalidArgumentException("The property value of PROFILE_APPEND should be a List<String>.");
        }
    }

    public static void assertValue(String type, String value) throws InvalidArgumentException {
        if (value == null || value.length() < 1) {
            throw new InvalidArgumentException(String.format("The %s value is empty or null.", type));
        }
        if (value.length() > 255) {
            throw new InvalidArgumentException(String.format("The %s value %s is too long, max length is 255.", type, value));
        }
    }

    public static void assertValue(String type, Object value) throws InvalidArgumentException {
        if (value instanceof String) {
            SensorsAnalyticsUtil.assertValue(type, (String)value);
        } else if (value instanceof List) {
            if (((List)value).size() == 0) {
                throw new InvalidArgumentException(String.format("%s value is empty.", type));
            }
            for (Object o : (List)value) {
                SensorsAnalyticsUtil.assertValue(type, (String)o);
            }
        } else {
            throw new InvalidArgumentException(String.format("Unsupported data type for the %s value", type));
        }
    }

    public static void assertKey(String type, String key) throws InvalidArgumentException {
        if (null == key || key.length() < 1) {
            throw new InvalidArgumentException(String.format("The %s key is empty or null.", type));
        }
        if (!KEY_PATTERN.matcher(key).matches()) {
            throw new InvalidArgumentException(String.format("The %s key '%s' is invalid.", type, key));
        }
    }

    public static Integer getTrackId(Map<String, Object> propertyMap, String message) {
        try {
            if (propertyMap.containsKey("$track_id")) {
                return Integer.parseInt(String.valueOf(propertyMap.remove("$track_id")));
            }
            return new Random().nextInt();
        }
        catch (Exception e) {
            log.error("Failed Get Track ID. {} ", (Object)message, (Object)e);
            return new Random().nextInt();
        }
    }

    public static String checkUserInfo(Long userId, Map<String, Object> identities, String distinctId) throws InvalidArgumentException {
        if (identities.isEmpty() && null == userId) {
            throw new InvalidArgumentException("missing user info node(identities/user_id).");
        }
        if (userId != null) {
            if (distinctId != null) {
                SensorsAnalyticsUtil.assertValue("distinct_id", distinctId);
                return distinctId;
            }
            return "SENSORS_ID:" + userId;
        }
        Pair<String, Boolean> userPair = SensorsAnalyticsUtil.checkIdentitiesAndGenerateDistinctId(distinctId, identities);
        return userPair.getKey();
    }

    public static Pair<String, Boolean> checkIdentitiesAndGenerateDistinctId(String distinctId, Map<String, Object> identities) throws InvalidArgumentException {
        if (distinctId != null) {
            SensorsAnalyticsUtil.assertValue("distinct_id", distinctId);
        }
        String tmpId = null;
        for (Map.Entry<String, Object> entry : identities.entrySet()) {
            SensorsAnalyticsUtil.assertKey("track", entry.getKey());
            SensorsAnalyticsUtil.assertValue("track", entry.getValue());
            if (tmpId != null || distinctId != null || (tmpId = String.format("%s+%s", entry.getKey(), entry.getValue())).length() <= 255) continue;
            tmpId = null;
        }
        boolean isLoginId = false;
        String id = tmpId;
        if (distinctId == null) {
            if (identities.containsKey("$identity_login_id")) {
                id = (String)identities.get("$identity_login_id");
                isLoginId = true;
            } else if (tmpId == null) {
                Object obj = identities.get(identities.keySet().iterator().next());
                if (obj instanceof String) {
                    id = (String)obj;
                } else if (obj instanceof List) {
                    id = (String)((List)obj).get(0);
                }
            } else {
                id = tmpId;
            }
        } else {
            id = distinctId;
        }
        return Pair.of(id, isLoginId);
    }

    public static void assertFailedData(FailedData failedData) throws InvalidArgumentException {
        if (failedData.getFailedData() == null || failedData.getFailedData().isEmpty()) {
            throw new InvalidArgumentException("Failed Data is null or empty.");
        }
        for (int i = 0; i < failedData.getFailedData().size(); ++i) {
            String type;
            Map<String, Object> dataMap = failedData.getFailedData().get(i);
            if (SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "type")) {
                throw new InvalidArgumentException(String.format("The index [%d] of failed data list have not [type].", i));
            }
            switch (type = String.valueOf(dataMap.get("type"))) {
                case "item_set": 
                case "item_delete": {
                    if (SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "item_id")) {
                        throw new InvalidArgumentException(String.format("The index [%d] of failed data list have not [item_id].", i));
                    }
                    SensorsAnalyticsUtil.assertValue("item id", dataMap.get("item_id").toString());
                    if (SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "item_type")) {
                        throw new InvalidArgumentException(String.format("The index [%d] of failed data list have not [item_type].", i));
                    }
                    SensorsAnalyticsUtil.assertValue("item type", dataMap.get("item_type").toString());
                    break;
                }
                case "track_signup": {
                    if (SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "original_id")) {
                        throw new InvalidArgumentException(String.format("The index [%d] of failed data list have not [original_id].", i));
                    }
                    SensorsAnalyticsUtil.assertValue("Original Distinct Id", dataMap.get("original_id").toString());
                }
                case "track_id_bind": 
                case "track_id_unbind": {
                    if (!"track_signup".equals(type) && SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "identities")) {
                        throw new InvalidArgumentException(String.format("The index [%d] of failed data list have not [identities].", i));
                    }
                }
                case "track": 
                case "profile_set": 
                case "profile_set_once": 
                case "profile_append": 
                case "profile_increment": 
                case "profile_unset": 
                case "profile_delete": {
                    if (SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "distinct_id")) {
                        throw new InvalidArgumentException(String.format("The index [%d] of failed data list have not [distinct_id].", i));
                    }
                    if (SensorsAnalyticsUtil.verifyMapValueIsBlank(dataMap, "_track_id") || !(dataMap.get("_track_id") instanceof Integer)) {
                        throw new InvalidArgumentException(String.format("The index [%d] of of failed data list is invalid.", i));
                    }
                    SensorsAnalyticsUtil.assertValue("Distinct Id", dataMap.get("distinct_id").toString());
                    break;
                }
                default: {
                    throw new InvalidArgumentException(String.format("The index [%d] of failed data list can not identify [action_type:%s].", i, type));
                }
            }
            if (dataMap.containsKey("properties")) {
                if (!(dataMap.get("properties") instanceof Map)) {
                    throw new InvalidArgumentException(String.format("The index [%d] of failed data list can not identify [properties:%s].", i, type));
                }
                SensorsAnalyticsUtil.assertProperties(type, (Map)dataMap.get("properties"));
            }
            if (dataMap.containsKey("time")) continue;
            dataMap.put("time", System.currentTimeMillis());
        }
    }

    public static List<Map<String, Object>> deepCopy(List<Map<String, Object>> source) {
        if (source == null) {
            return null;
        }
        ArrayList<Map<String, Object>> newList = new ArrayList<Map<String, Object>>(source.size());
        for (Map<String, Object> objectMap : source) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(objectMap.size());
            newMap.putAll(objectMap);
            newList.add(newMap);
        }
        return newList;
    }

    private static boolean verifyMapValueIsBlank(Map<String, Object> map, String key) {
        return map == null || !map.containsKey(key) || map.get(key) == null;
    }

    public static void assertSchema(String schema) throws InvalidArgumentException {
        if (null == schema || "".equals(schema)) {
            throw new InvalidArgumentException("The schema can not set null or empty.");
        }
        if (!KEY_PATTERN.matcher(schema).matches()) {
            throw new InvalidArgumentException(String.format("Thr schema '%s' is invalid.", schema));
        }
    }

    public static void assertSchemaProperties(Map<String, Object> properties, String actionType) throws InvalidArgumentException {
        if (properties.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            SensorsAnalyticsUtil.assertKey("property", entry.getKey());
            Object value = entry.getValue();
            if ("$time".equals(entry.getKey()) && !(value instanceof Date)) {
                throw new InvalidArgumentException("The property '$time' should be a java.util.Date.");
            }
            switch (SensorsDataTypeEnum.getDataType(value)) {
                case NUMBER: 
                case BOOLEAN: 
                case DATE: {
                    break;
                }
                case LIST: {
                    List valueList = (List)value;
                    ListIterator<String> listIterator = valueList.listIterator();
                    while (listIterator.hasNext()) {
                        Object next = listIterator.next();
                        if (!(next instanceof String)) {
                            throw new InvalidArgumentException(String.format("The property '%s' should be a list of String.", entry.getKey()));
                        }
                        if (((String)next).length() <= 8192) continue;
                        listIterator.set(((String)next).substring(0, 8192));
                    }
                    break;
                }
                case STRING: {
                    if (((String)value).length() <= 8192) break;
                    entry.setValue(((String)value).substring(0, 8192));
                    break;
                }
                default: {
                    throw new InvalidArgumentException(String.format("The property '%s' should be a basic type: Number, String, Date, Boolean, List<String>.The current type is %s.", entry.getKey(), value.getClass().getName()));
                }
            }
            if ("profile_increment".equals(actionType) && !"$project".equals(entry.getKey()) && !"$token".equals(entry.getKey()) && !(value instanceof Number)) {
                throw new InvalidArgumentException(String.format("The property value of PROFILE_INCREMENT should be a Number.The current type is %s.", value.getClass().getName()));
            }
            if ("profile_append".equals(actionType) && !"$project".equals(entry.getKey()) && !"$token".equals(entry.getKey()) && !(value instanceof List)) {
                throw new InvalidArgumentException(String.format("The property value of PROFILE_APPEND should be a List<String>.The current type is %s.", value.getClass().getName()));
            }
            if (!"profile_unset".equals(actionType) || value instanceof Boolean && Boolean.parseBoolean(value.toString())) continue;
            throw new InvalidArgumentException("The property value of " + entry.getKey() + " should be true.");
        }
    }

    public static String toString(Map<String, String> identities) {
        if (identities == null) {
            return null;
        }
        StringBuilder res = new StringBuilder("");
        for (Map.Entry<String, String> entry : identities.entrySet()) {
            res.append("{").append(entry.getKey()).append(":").append(entry.getValue()).append("},");
        }
        return res.toString();
    }

    public static void assertEventItemPair(Pair<String, String> itemPair) throws InvalidArgumentException {
        if (itemPair == null) {
            throw new InvalidArgumentException("item event record must be set item id info");
        }
        SensorsAnalyticsUtil.assertKey("item event id", itemPair.getKey());
        SensorsAnalyticsUtil.assertValue("item event value", itemPair.getValue());
    }
}

