/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.sensorsdata.analytics.javasdk.util.Base64Coder;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.Timeout;

class HttpConsumer
implements Closeable {
    CloseableHttpClient httpClient;
    final String serverUrl;
    final Map<String, String> httpHeaders;
    final boolean compressData;
    final RequestConfig requestConfig;

    public HttpConsumer(String serverUrl, int timeoutSec) {
        this(HttpClients.custom(), serverUrl, null, timeoutSec);
    }

    public HttpConsumer(String serverUrl, Map<String, String> httpHeaders) {
        this(HttpClients.custom(), serverUrl, httpHeaders, 3);
    }

    HttpConsumer(String serverUrl, Map<String, String> httpHeaders, int timeoutSec) {
        this(HttpClients.custom(), serverUrl, httpHeaders, timeoutSec);
    }

    public HttpConsumer(HttpClientBuilder httpClientBuilder, String serverUrl, Map<String, String> httpHeaders) {
        this(httpClientBuilder, serverUrl, httpHeaders, 3);
    }

    public HttpConsumer(HttpClientBuilder httpClientBuilder, String serverUrl, int timeoutSec) {
        this(httpClientBuilder, serverUrl, null, timeoutSec);
    }

    HttpConsumer(HttpClientBuilder httpClientBuilder, String serverUrl, Map<String, String> httpHeaders, int timeoutSec) {
        this.serverUrl = serverUrl.trim();
        this.httpHeaders = httpHeaders;
        this.compressData = true;
        Timeout timeout = Timeout.ofSeconds((long)timeoutSec);
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setResponseTimeout(timeout).build();
        this.httpClient = httpClientBuilder.setUserAgent(String.format("SensorsAnalytics Java SDK %s", "3.6.9")).setDefaultRequestConfig(this.requestConfig).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void consume(String data) throws IOException, HttpConsumerException {
        HttpPost request = this.getHttpRequest(data);
        CloseableHttpResponse response = null;
        if (this.httpClient == null) {
            this.httpClient = HttpClients.custom().setUserAgent(String.format("SensorsAnalytics Java SDK %s", "3.6.9")).setDefaultRequestConfig(this.requestConfig).build();
        }
        try {
            response = this.httpClient.execute((ClassicHttpRequest)request);
            int httpStatusCode = response.getCode();
            if (httpStatusCode < 200 || httpStatusCode >= 300) {
                String httpContent = new String(EntityUtils.toByteArray((HttpEntity)response.getEntity()), StandardCharsets.UTF_8);
                throw new HttpConsumerException(String.format("Unexpected response %d from Sensors Analytics: %s", httpStatusCode, httpContent), data, httpStatusCode, httpContent);
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    HttpPost getHttpRequest(String data) throws IOException {
        HttpPost httpPost = new HttpPost(this.serverUrl);
        httpPost.setEntity((HttpEntity)this.getHttpEntry(data));
        if (this.httpHeaders != null) {
            for (Map.Entry<String, String> entry : this.httpHeaders.entrySet()) {
                httpPost.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        return httpPost;
    }

    UrlEncodedFormEntity getHttpEntry(String data) throws IOException {
        List<NameValuePair> nameValuePairs = this.getNameValuePairs(data);
        return new UrlEncodedFormEntity(nameValuePairs);
    }

    List<NameValuePair> getNameValuePairs(String data) throws IOException {
        byte[] bytes = data.getBytes(Charset.forName("UTF-8"));
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        if (this.compressData) {
            ByteArrayOutputStream os = new ByteArrayOutputStream(bytes.length);
            GZIPOutputStream gos = new GZIPOutputStream(os);
            gos.write(bytes);
            gos.close();
            byte[] compressed = os.toByteArray();
            os.close();
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("gzip", "1"));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("data_list", new String(Base64Coder.encode(compressed))));
        } else {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("gzip", "0"));
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("data_list", new String(Base64Coder.encode(bytes))));
        }
        return nameValuePairs;
    }

    @Override
    public synchronized void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
                this.httpClient = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class HttpConsumerException
    extends Exception {
        final String sendingData;
        final int httpStatusCode;
        final String httpContent;

        HttpConsumerException(String error, String sendingData, int httpStatusCode, String httpContent) {
            super(error);
            this.sendingData = sendingData;
            this.httpStatusCode = httpStatusCode;
            this.httpContent = httpContent;
        }

        String getSendingData() {
            return this.sendingData;
        }

        int getHttpStatusCode() {
            return this.httpStatusCode;
        }

        String getHttpContent() {
            return this.httpContent;
        }
    }
}

