/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.HttpConsumer;
import com.sensorsdata.analytics.javasdk.exceptions.DebugModeException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(DebugConsumer.class);
    final HttpConsumer httpConsumer;
    final ObjectMapper jsonMapper;

    public DebugConsumer(String serverUrl, boolean writeData) {
        this(HttpClients.custom(), serverUrl, writeData);
    }

    public DebugConsumer(HttpClientBuilder httpClientBuilder, String serverUrl, boolean writeData) {
        String debugUrl;
        try {
            URIBuilder builder = new URIBuilder(new URI(serverUrl));
            String[] urlPathes = builder.getPath().split("/");
            urlPathes[urlPathes.length - 1] = "debug";
            builder.setPath(SensorsAnalyticsUtil.strJoin(urlPathes, "/"));
            debugUrl = builder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            log.error("Failed build debug url:[{}].", (Object)serverUrl, (Object)e);
            throw new DebugModeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (!writeData) {
            headers.put("Dry-Run", "true");
        }
        this.httpConsumer = new HttpConsumer(httpClientBuilder, debugUrl, headers);
        this.jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
        log.info("Initialize DebugConsumer with params:[writeData:{}].", (Object)writeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Map<String, Object> message) {
        String sendingData;
        ArrayList<Map<String, Object>> messageList = new ArrayList<Map<String, Object>>();
        messageList.add(message);
        try {
            sendingData = this.jsonMapper.writeValueAsString(messageList);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to process json.", (Throwable)e);
            throw new RuntimeException("Failed to serialize data.", e);
        }
        try {
            HttpConsumer e = this.httpConsumer;
            synchronized (e) {
                this.httpConsumer.consume(sendingData);
            }
            log.debug("Successfully send data:[{}].", (Object)sendingData);
        }
        catch (IOException e) {
            log.error("Failed to send message with DebugConsumer,message:[{}].", (Object)sendingData, (Object)e);
            throw new DebugModeException("Failed to send message with DebugConsumer.", e);
        }
        catch (HttpConsumer.HttpConsumerException e) {
            log.error("Failed send message with server occur error,message:[{}].", (Object)sendingData, (Object)e);
            throw new DebugModeException(e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.httpConsumer.close();
    }
}

