/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(ConsoleConsumer.class);
    private final ObjectMapper jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
    private final Writer writer;

    public ConsoleConsumer(Writer writer) {
        this.writer = writer;
        log.info("Initialize ConsoleConsumer.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Map<String, Object> message) {
        try {
            Writer writer = this.writer;
            synchronized (writer) {
                this.writer.write(this.jsonMapper.writeValueAsString(message));
                this.writer.write("\n");
            }
        }
        catch (IOException e) {
            log.error("Failed to dump message with ConsoleConsumer.", (Throwable)e);
            throw new RuntimeException("Failed to dump message with ConsoleConsumer.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Writer writer = this.writer;
        synchronized (writer) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                log.error("Failed to flush with ConsoleConsumer.", (Throwable)e);
                throw new RuntimeException("Failed to flush with ConsoleConsumer.", e);
            }
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

