/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.sensorsdata.analytics.javasdk.consumer.InnerLoggingConsumer;
import com.sensorsdata.analytics.javasdk.consumer.LogSplitMode;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriter;
import com.sensorsdata.analytics.javasdk.consumer.LoggingFileWriterFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentLoggingConsumer
extends InnerLoggingConsumer {
    private static final Logger log = LoggerFactory.getLogger(ConcurrentLoggingConsumer.class);

    public ConcurrentLoggingConsumer(String filenamePrefix) {
        this(filenamePrefix, null);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, int bufferSize) {
        this(filenamePrefix, null, bufferSize);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName) {
        this(filenamePrefix, lockFileName, 8192);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName, int bufferSize) {
        this(filenamePrefix, lockFileName, bufferSize, LogSplitMode.DAY);
    }

    public ConcurrentLoggingConsumer(String filenamePrefix, String lockFileName, int bufferSize, LogSplitMode splitMode) {
        super(new InnerLoggingFileWriterFactory(lockFileName), filenamePrefix, bufferSize, splitMode);
    }

    static class InnerLoggingFileWriterFactory
    implements LoggingFileWriterFactory {
        private String lockFileName;

        InnerLoggingFileWriterFactory(String lockFileName) {
            this.lockFileName = lockFileName;
        }

        @Override
        public LoggingFileWriter getFileWriter(String fileName, String scheduleFileName) throws FileNotFoundException {
            return InnerLoggingFileWriter.getInstance(scheduleFileName, this.lockFileName);
        }

        @Override
        public void closeFileWriter(LoggingFileWriter writer) {
            InnerLoggingFileWriter.removeInstance((InnerLoggingFileWriter)writer);
        }
    }

    static class InnerLoggingFileWriter
    implements LoggingFileWriter {
        private final Object fileLock = new Object();
        private final String fileName;
        private final String lockFileName;
        private FileOutputStream outputStream;
        private FileOutputStream lockStream;
        private int refCount;
        private static final Map<String, InnerLoggingFileWriter> instances = new HashMap<String, InnerLoggingFileWriter>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static InnerLoggingFileWriter getInstance(String fileName, String lockFileName) throws FileNotFoundException {
            Map<String, InnerLoggingFileWriter> map = instances;
            synchronized (map) {
                if (!instances.containsKey(fileName)) {
                    instances.put(fileName, new InnerLoggingFileWriter(fileName, lockFileName));
                }
                InnerLoggingFileWriter writer = instances.get(fileName);
                ++writer.refCount;
                return writer;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void removeInstance(InnerLoggingFileWriter writer) {
            Map<String, InnerLoggingFileWriter> map = instances;
            synchronized (map) {
                --writer.refCount;
                if (writer.refCount == 0) {
                    writer.close();
                    instances.remove(writer.fileName);
                }
            }
        }

        private InnerLoggingFileWriter(String fileName, String lockFileName) throws FileNotFoundException {
            this.fileName = fileName;
            this.lockFileName = lockFileName;
            this.refCount = 0;
            this.initLock();
        }

        @Override
        public void close() {
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                log.error("Failed to close output stream.", (Throwable)e);
                throw new RuntimeException("fail to close output stream.", e);
            }
        }

        @Override
        public boolean isValid(String fileName) {
            return this.fileName.equals(fileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(StringBuilder sb) {
            Object object = this.fileLock;
            synchronized (object) {
                FileLock lock = null;
                try {
                    FileChannel channel = this.lockStream.getChannel();
                    if (!channel.isOpen()) {
                        this.lockStream.close();
                        this.outputStream.close();
                        this.initLock();
                    }
                    lock = channel.lock(0L, Long.MAX_VALUE, false);
                    this.outputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    log.error("Failed to write file.", (Throwable)e);
                    throw new RuntimeException("fail to write file.", e);
                }
                finally {
                    if (lock != null) {
                        try {
                            lock.release();
                        }
                        catch (IOException e) {
                            log.error("Failed to release file lock.", (Throwable)e);
                            throw new RuntimeException("fail to release file lock.", e);
                        }
                    }
                }
            }
            return true;
        }

        private void initLock() throws FileNotFoundException {
            this.outputStream = new FileOutputStream(this.fileName, true);
            this.lockStream = this.lockFileName != null ? new FileOutputStream(this.lockFileName, true) : this.outputStream;
        }
    }
}

