/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.consumer.HttpConsumer;
import com.sensorsdata.analytics.javasdk.consumer.InstantHttpConsumer;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(BatchConsumer.class);
    private static final int MAX_FLUSH_BULK_SIZE = 1000;
    private static final int MAX_CACHE_SIZE = 6000;
    private static final int MIN_CACHE_SIZE = 3000;
    private final List<Map<String, Object>> messageList = new LinkedList<Map<String, Object>>();
    private final HttpConsumer httpConsumer;
    private final InstantHttpConsumer instantHttpConsumer;
    private final ObjectMapper jsonMapper;
    private final int bulkSize;
    private final boolean throwException;
    private final int maxCacheSize;
    private List<String> instantEvents;
    private boolean isInstantStatus = false;

    public BatchConsumer(String serverUrl) {
        this(serverUrl, 50);
    }

    public BatchConsumer(String serverUrl, int bulkSize) {
        this(serverUrl, bulkSize, 3);
    }

    public BatchConsumer(String serverUrl, int bulkSize, int timeoutSec) {
        this(serverUrl, bulkSize, false, timeoutSec);
    }

    public BatchConsumer(String serverUrl, int bulkSize, boolean throwException) {
        this(serverUrl, bulkSize, throwException, 3);
    }

    public BatchConsumer(String serverUrl, int bulkSize, boolean throwException, int timeoutSec) {
        this(serverUrl, bulkSize, 0, throwException, timeoutSec);
    }

    public BatchConsumer(String serverUrl, int bulkSize, int maxCacheSize, boolean throwException) {
        this(serverUrl, bulkSize, maxCacheSize, throwException, 3);
    }

    public BatchConsumer(String serverUrl, int bulkSize, int maxCacheSize, boolean throwException, int timeoutSec) {
        this(HttpClients.custom(), serverUrl, bulkSize, maxCacheSize, throwException, timeoutSec);
    }

    public BatchConsumer(HttpClientBuilder httpClientBuilder, String serverUrl, int bulkSize, int maxCacheSize, boolean throwException, int timeoutSec) {
        this(httpClientBuilder, serverUrl, bulkSize, maxCacheSize, throwException, timeoutSec, new ArrayList<String>());
    }

    public BatchConsumer(String serverUrl, int bulkSize, int maxCacheSize, boolean throwException, int timeoutSec, List<String> instantEvents) {
        this(HttpClients.custom(), serverUrl, bulkSize, maxCacheSize, throwException, timeoutSec, instantEvents);
    }

    public BatchConsumer(HttpClientBuilder httpClientBuilder, String serverUrl, int bulkSize, int maxCacheSize, boolean throwException, int timeoutSec, List<String> instantEvents) {
        this.instantEvents = instantEvents;
        this.httpConsumer = new HttpConsumer(httpClientBuilder, serverUrl, Math.max(timeoutSec, 1));
        this.instantHttpConsumer = new InstantHttpConsumer(httpClientBuilder, serverUrl, Math.max(timeoutSec, 1));
        this.jsonMapper = SensorsAnalyticsUtil.getJsonObjectMapper();
        this.bulkSize = Math.min(1000, Math.max(1, bulkSize));
        this.maxCacheSize = maxCacheSize > 6000 ? 6000 : (maxCacheSize > 0 && maxCacheSize < 3000 ? 3000 : maxCacheSize);
        this.throwException = throwException;
        log.info("Initialize BatchConsumer with params:[bulkSize:{},timeoutSec:{},maxCacheSize:{},throwException:{}]", new Object[]{bulkSize, timeoutSec, maxCacheSize, throwException});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Map<String, Object> message) {
        List<Map<String, Object>> list = this.messageList;
        synchronized (list) {
            this.dealInstantSignal(message);
            int size = this.messageList.size();
            if (this.maxCacheSize <= 0 || size < this.maxCacheSize) {
                this.messageList.add(message);
                log.debug("Successfully save data to cache,The cache current size is {}.", (Object)(++size));
            }
            if (size >= this.bulkSize) {
                log.info("Flush was triggered because the cache size reached the threshold,cache size:{},bulkSize:{}.", (Object)size, (Object)this.bulkSize);
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        List<Map<String, Object>> list = this.messageList;
        synchronized (list) {
            while (!this.messageList.isEmpty()) {
                String sendingData;
                List<Map<String, Object>> sendList = this.messageList.subList(0, Math.min(this.bulkSize, this.messageList.size()));
                try {
                    sendingData = this.jsonMapper.writeValueAsString(sendList);
                }
                catch (JsonProcessingException e) {
                    sendList.clear();
                    log.error("Failed to process json.", (Throwable)e);
                    if (!this.throwException) continue;
                    throw new RuntimeException("Failed to serialize data.", e);
                }
                log.debug("Will be send data:{}.", (Object)sendingData);
                try {
                    if (this.isInstantStatus) {
                        this.instantHttpConsumer.consume(sendingData);
                    } else {
                        this.httpConsumer.consume(sendingData);
                    }
                    sendList.clear();
                }
                catch (Exception e) {
                    log.error("Failed to send data:{}.", (Object)sendingData, (Object)e);
                    if (this.throwException) {
                        throw new RuntimeException("Failed to dump message with BatchConsumer.", e);
                    }
                    return;
                }
                log.debug("Successfully send data:{}.", (Object)sendingData);
            }
            log.info("Finish flush.");
        }
    }

    @Override
    public void close() {
        this.flush();
        this.httpConsumer.close();
        log.info("Call close method.");
    }

    private void dealInstantSignal(Map<String, Object> message) {
        if (!(!this.isInstantStatus || message.containsKey("event") && this.instantEvents.contains(message.get("event")))) {
            this.flush();
            this.isInstantStatus = false;
        }
        if (!this.isInstantStatus && message.containsKey("event") && this.instantEvents.contains(message.get("event"))) {
            this.flush();
            this.isInstantStatus = true;
        }
    }
}

