/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean.schema;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class UserSchema {
    private Long userId;
    private Map<String, Object> propertyMap;
    private String distinctId;
    private Integer trackId;
    private Map<String, Object> identityMap;

    protected UserSchema(Map<String, Object> identityMap, Map<String, Object> propertyMap, String distinctId, Integer trackId, Long userId) {
        this.userId = userId;
        this.propertyMap = propertyMap;
        this.distinctId = distinctId;
        this.trackId = trackId;
        this.identityMap = identityMap;
    }

    public static USBuilder init() {
        return new USBuilder();
    }

    public Long getUserId() {
        return this.userId;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public Map<String, Object> getIdentityMap() {
        return this.identityMap;
    }

    public static class USBuilder {
        private Map<String, Object> idMap = new LinkedHashMap<String, Object>();
        private String distinctId;
        private Integer trackId;
        private Long userId;
        private Map<String, Object> properties = new HashMap<String, Object>();

        private USBuilder() {
        }

        public UserSchema start() throws InvalidArgumentException {
            this.distinctId = SensorsAnalyticsUtil.checkUserInfo(this.userId, this.idMap, this.distinctId);
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.properties, String.format("[distinct_id=%s,user_id=%s]", this.distinctId, this.userId));
            return new UserSchema(this.idMap, this.properties, this.distinctId, this.trackId, this.userId);
        }

        public USBuilder setUserId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public USBuilder identityMap(@NonNull Map<String, Object> identityMap) {
            if (identityMap == null) {
                throw new NullPointerException("identityMap is marked non-null but is null");
            }
            this.idMap.putAll(identityMap);
            return this;
        }

        public USBuilder addIdentityProperty(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.idMap.put(key, value);
            return this;
        }

        public USBuilder addIdentityProperty(@NonNull String key, @NonNull List<String> value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.idMap.put(key, value);
            return this;
        }

        public USBuilder setDistinctId(@NonNull String distinctId) {
            if (distinctId == null) {
                throw new NullPointerException("distinctId is marked non-null but is null");
            }
            this.distinctId = distinctId;
            return this;
        }

        public USBuilder addProperties(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties.putAll(properties);
            return this;
        }

        public USBuilder addProperty(@NonNull String key, @NonNull String property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public USBuilder addProperty(@NonNull String key, boolean property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public USBuilder addProperty(@NonNull String key, @NonNull Number property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public USBuilder addProperty(@NonNull String key, @NonNull Date property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public USBuilder addProperty(@NonNull String key, @NonNull List<String> property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(@NonNull String key, @NonNull Object property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.properties.put(key, property);
        }
    }
}

