/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean.schema;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class UserEventSchema {
    private Integer trackId;
    private Long userId;
    private String eventName;
    private String distinctId;
    private Map<String, Object> propertyMap;
    private Map<String, Object> identityMap;

    protected UserEventSchema(Map<String, Object> identityMap, String eventName, String distinctId, Map<String, Object> propertyMap, Integer trackId, Long userId) {
        this.eventName = eventName;
        this.distinctId = distinctId;
        this.propertyMap = propertyMap;
        this.trackId = trackId;
        this.identityMap = identityMap;
        this.userId = userId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public static UESBuilder init() {
        return new UESBuilder();
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public Map<String, Object> getIdentityMap() {
        return this.identityMap;
    }

    public static class UESBuilder {
        private Map<String, Object> idMap = new LinkedHashMap<String, Object>();
        private Long userId;
        private String distinctId;
        private String eventName;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Integer trackId;

        private UESBuilder() {
        }

        public UserEventSchema start() throws InvalidArgumentException {
            SensorsAnalyticsUtil.assertKey("event_name", this.eventName);
            if (!this.properties.isEmpty()) {
                SensorsAnalyticsUtil.assertSchemaProperties(this.properties, "track");
            }
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.properties, String.format("[distinct_id=%s,event_name=%s]", this.distinctId, this.eventName));
            this.distinctId = SensorsAnalyticsUtil.checkUserInfo(this.userId, this.idMap, this.distinctId);
            return new UserEventSchema(this.idMap, this.eventName, this.distinctId, this.properties, this.trackId, this.userId);
        }

        public UESBuilder setUserId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public UESBuilder identityMap(@NonNull Map<String, String> identityMap) {
            if (identityMap == null) {
                throw new NullPointerException("identityMap is marked non-null but is null");
            }
            this.idMap.putAll(identityMap);
            return this;
        }

        public UESBuilder addIdentityProperty(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.idMap.put(key, value);
            return this;
        }

        public UESBuilder setEventName(@NonNull String eventName) {
            if (eventName == null) {
                throw new NullPointerException("eventName is marked non-null but is null");
            }
            this.eventName = eventName;
            return this;
        }

        public UESBuilder setDistinctId(@NonNull String distinctId) {
            if (distinctId == null) {
                throw new NullPointerException("distinctId is marked non-null but is null");
            }
            this.distinctId = distinctId;
            return this;
        }

        public UESBuilder addProperties(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties.putAll(properties);
            return this;
        }

        public UESBuilder addProperty(@NonNull String key, @NonNull String property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public UESBuilder addProperty(@NonNull String key, boolean property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public UESBuilder addProperty(@NonNull String key, @NonNull Number property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public UESBuilder addProperty(@NonNull String key, @NonNull Date property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public UESBuilder addProperty(@NonNull String key, @NonNull List<String> property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(@NonNull String key, @NonNull Object property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.properties.put(key, property);
        }
    }
}

