/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean.schema;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ItemSchema {
    private String schema;
    private String itemId;
    private Map<String, Object> properties;
    private Integer trackId;

    protected ItemSchema(Integer trackId, String schema, String itemId, Map<String, Object> properties) {
        this.trackId = trackId;
        this.schema = schema;
        this.itemId = itemId;
        this.properties = properties;
    }

    public static ISBuilder init() {
        return new ISBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getItemId() {
        return this.itemId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public static class ISBuilder {
        private String schema;
        private String itemId;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Integer trackId;

        private ISBuilder() {
        }

        public ItemSchema start() throws InvalidArgumentException {
            if (this.itemId == null) {
                throw new InvalidArgumentException("The item id can not set null.");
            }
            SensorsAnalyticsUtil.assertValue("itemId", this.itemId);
            SensorsAnalyticsUtil.assertSchema(this.schema);
            SensorsAnalyticsUtil.assertSchemaProperties(this.properties, null);
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.properties, String.format("[itemId=%s,schema=%s]", this.itemId, this.schema));
            return new ItemSchema(this.trackId, this.schema, this.itemId, this.properties);
        }

        public ISBuilder setSchema(@NonNull String schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        public ISBuilder setItemId(@NonNull String itemId) {
            if (itemId == null) {
                throw new NullPointerException("itemId is marked non-null but is null");
            }
            this.itemId = itemId;
            return this;
        }

        public ISBuilder addProperties(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties.putAll(properties);
            return this;
        }

        public ISBuilder addProperty(@NonNull String key, @NonNull String property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public ISBuilder addProperty(@NonNull String key, boolean property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public ISBuilder addProperty(@NonNull String key, @NonNull Number property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public ISBuilder addProperty(@NonNull String key, @NonNull Date property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public ISBuilder addProperty(@NonNull String key, @NonNull List<String> property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(@NonNull String key, @NonNull Object property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.properties.put(key, property);
        }
    }
}

