/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean.schema;

import com.sensorsdata.analytics.javasdk.common.Pair;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ItemEventSchema {
    private String schema;
    private String eventName;
    private Map<String, Object> properties;
    private Integer trackId;
    private Pair<String, String> itemPair;

    protected ItemEventSchema(Integer trackId, String schema, String eventName, Pair<String, String> itemPair, Map<String, Object> properties) {
        this.trackId = trackId;
        this.schema = schema;
        this.eventName = eventName;
        this.properties = properties;
        this.itemPair = itemPair;
    }

    public static IEBuilder init() {
        return new IEBuilder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public Pair<String, String> getItemPair() {
        return this.itemPair;
    }

    public static class IEBuilder {
        private String schema;
        private String eventName;
        private Integer trackId;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Pair<String, String> itemPair;

        public ItemEventSchema start() throws InvalidArgumentException {
            SensorsAnalyticsUtil.assertSchema(this.schema);
            SensorsAnalyticsUtil.assertEventItemPair(this.itemPair);
            SensorsAnalyticsUtil.assertKey("event_name", this.eventName);
            SensorsAnalyticsUtil.assertSchemaProperties(this.properties, null);
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.properties, String.format("[event=%s,schema=%s]", this.eventName, this.schema));
            return new ItemEventSchema(this.trackId, this.schema, this.eventName, this.itemPair, this.properties);
        }

        public IEBuilder setSchema(@NonNull String schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        public IEBuilder setEventName(@NonNull String eventName) {
            if (eventName == null) {
                throw new NullPointerException("eventName is marked non-null but is null");
            }
            this.eventName = eventName;
            return this;
        }

        public IEBuilder setItemPair(@NonNull String itemId, @NonNull String value) {
            if (itemId == null) {
                throw new NullPointerException("itemId is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.itemPair = Pair.of(itemId, value);
            return this;
        }

        public IEBuilder addProperties(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties.putAll(properties);
            return this;
        }

        public IEBuilder addProperty(@NonNull String key, @NonNull String property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public IEBuilder addProperty(@NonNull String key, boolean property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public IEBuilder addProperty(@NonNull String key, @NonNull Number property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public IEBuilder addProperty(@NonNull String key, @NonNull Date property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public IEBuilder addProperty(@NonNull String key, @NonNull List<String> property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(@NonNull String key, @NonNull Object property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.properties.put(key, property);
        }
    }
}

