/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean.schema;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class IdentitySchema {
    private Map<String, String> idMap;
    private Map<String, Object> properties;

    protected IdentitySchema(Map<String, String> idMap, Map<String, Object> properties) {
        this.idMap = idMap;
        this.properties = properties;
    }

    public static Builder init() {
        return new Builder();
    }

    public Map<String, String> getIdMap() {
        return this.idMap;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Map<String, String> idMap = new LinkedHashMap<String, String>();
        private Map<String, Object> properties = new HashMap<String, Object>();

        public Builder identityMap(Map<String, String> identityMap) {
            if (identityMap != null) {
                this.idMap.putAll(identityMap);
            }
            return this;
        }

        public Builder addIdentityProperty(String key, String value) {
            this.idMap.put(key, value);
            return this;
        }

        public Builder addProperties(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties.putAll(properties);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull String property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, boolean property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull Number property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull Date property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull List<String> property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(@NonNull String key, @NonNull Object property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.properties.put(key, property);
        }

        public IdentitySchema build() {
            return new IdentitySchema(this.idMap, this.properties);
        }
    }
}

