/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean.schema;

import com.sensorsdata.analytics.javasdk.common.Pair;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class DetailSchema {
    private String schema;
    private String detailId;
    private Map<String, Object> properties;
    private Map<String, Object> identities;
    private String distinctId;
    private Pair<String, String> itemPair;
    private Integer trackId;

    protected DetailSchema(String schema, String detailId, Map<String, Object> properties, Map<String, Object> identities, String distinctId, Pair<String, String> itemPair, Integer trackId) {
        this.schema = schema;
        this.detailId = detailId;
        this.properties = properties;
        this.identities = identities;
        this.distinctId = distinctId;
        this.itemPair = itemPair;
        this.trackId = trackId;
    }

    public static Builder init() {
        return new Builder();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getDetailId() {
        return this.detailId;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getIdentities() {
        return this.identities;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Pair<String, String> getItemPair() {
        return this.itemPair;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public static class Builder {
        private String schema;
        private String detailId;
        private Map<String, Object> properties = new HashMap<String, Object>();
        private Map<String, Object> identities = new LinkedHashMap<String, Object>();
        private String distinctId;
        private Pair<String, String> itemPair;
        private Integer trackId;

        public DetailSchema start() throws InvalidArgumentException {
            SensorsAnalyticsUtil.assertSchema(this.schema);
            SensorsAnalyticsUtil.assertValue("detail_id", this.detailId);
            if (!this.identities.isEmpty() && null != this.itemPair) {
                throw new InvalidArgumentException("detail schema cannot both set identities and itemPair.");
            }
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.properties, String.format("detail generate trackId error.[distinct_id=%s,detail_id=%s,schema=%s]", this.distinctId, this.detailId, this.schema));
            if (!this.identities.isEmpty()) {
                this.distinctId = SensorsAnalyticsUtil.checkUserInfo(null, this.identities, this.distinctId);
            }
            SensorsAnalyticsUtil.assertSchemaProperties(this.properties, null);
            return new DetailSchema(this.schema, this.detailId, this.properties, this.identities, this.distinctId, this.itemPair, this.trackId);
        }

        public Builder setSchema(@NonNull String schema) {
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            this.schema = schema;
            return this;
        }

        public Builder setDetailId(@NonNull String detailId) {
            if (detailId == null) {
                throw new NullPointerException("detailId is marked non-null but is null");
            }
            this.detailId = detailId;
            return this;
        }

        public Builder setItemPair(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.itemPair = Pair.of(key, value);
            return this;
        }

        public Builder addProperties(@NonNull Map<String, Object> properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties.putAll(properties);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull String property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, boolean property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull Number property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull Date property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(@NonNull String key, @NonNull List<String> property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder identityMap(@NonNull Map<String, String> identities) {
            if (identities == null) {
                throw new NullPointerException("identities is marked non-null but is null");
            }
            this.identities.putAll(identities);
            return this;
        }

        public Builder addIdentityProperty(@NonNull String key, @NonNull String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.identities.put(key, value);
            return this;
        }

        public Builder setDistinctId(@NonNull String distinctId) {
            if (distinctId == null) {
                throw new NullPointerException("distinctId is marked non-null but is null");
            }
            this.distinctId = distinctId;
            return this;
        }

        private void addPropertyObject(@NonNull String key, @NonNull Object property) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (property == null) {
                throw new NullPointerException("property is marked non-null but is null");
            }
            this.properties.put(key, property);
        }
    }
}

